/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public final class OrdinalFormat {
    public static void apply(MessageFormat format) {
        Format[] formats = format.getFormats();
        NumberFormat ordinal = null;
        for (int i = 0; i < formats.length; ++i) {
            Format element = formats[i];
            if (!(element instanceof DecimalFormat) || !"ordinal".equals(((DecimalFormat)element).getPositivePrefix())) continue;
            if (ordinal == null) {
                ordinal = OrdinalFormat.getOrdinalFormat(format.getLocale());
            }
            format.setFormat(i, ordinal);
        }
    }

    private static NumberFormat getOrdinalFormat(Locale locale) {
        String language2;
        if (locale != null && ("en".equals(language2 = locale.getLanguage()) || language2 != null && language2.length() == 0)) {
            return new EnglishOrdinalFormat();
        }
        return new DecimalFormat();
    }

    public static String formatEnglish(long num) {
        long mod = Math.abs(num) % 100L;
        if (mod < 11L || mod > 13L) {
            if ((mod %= 10L) == 1L) {
                return num + "st";
            }
            if (mod == 2L) {
                return num + "nd";
            }
            if (mod == 3L) {
                return num + "rd";
            }
        }
        return num + "th";
    }

    private static class EnglishOrdinalFormat
    extends NumberFormat {
        private EnglishOrdinalFormat() {
        }

        @Override
        public StringBuffer format(long number2, StringBuffer toAppendTo, FieldPosition pos) {
            return new MessageFormat("{0}").format(new Object[]{OrdinalFormat.formatEnglish(number2)}, toAppendTo, pos);
        }

        @Override
        public StringBuffer format(double number2, StringBuffer toAppendTo, FieldPosition pos) {
            throw new IllegalArgumentException("Cannot format non-integer number");
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

