/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.server.model.Session;

public abstract class TimedSession
extends Session {
    private static final Logger logger = Logger.getLogger(TimedSession.class.getName());
    private Timer timer = new Timer();

    protected TimedSession(String key, long timeout) {
        super(key);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TimedSession.this.complete(false);
            }
        }, timeout * 1000L);
    }

    protected abstract boolean complete(boolean var1);

    protected synchronized void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public boolean complete(ChangeSet cs) {
        boolean ret = super.complete(cs);
        this.cancel();
        return ret;
    }
}

