/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.CanvasMapEditorMouseListener;
import net.sf.freecol.client.gui.CanvasMouseListener;
import net.sf.freecol.client.gui.CanvasMouseMotionListener;
import net.sf.freecol.client.gui.FrameMotionListener;
import net.sf.freecol.client.gui.FreeColFrame;
import net.sf.freecol.client.gui.GrayLayer;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.Scrolling;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.mapviewer.CanvasMapViewer;
import net.sf.freecol.client.gui.mapviewer.MapViewer;
import net.sf.freecol.client.gui.menu.InGameMenuBar;
import net.sf.freecol.client.gui.menu.MapEditorMenuBar;
import net.sf.freecol.client.gui.menu.MenuMouseMotionListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MainPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.video.VideoComponent;
import net.sf.freecol.client.gui.video.VideoListener;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.Video;
import net.sf.freecol.common.util.CollectionUtils;

public final class Canvas
extends JDesktopPane {
    private static final Logger logger = Logger.getLogger(Canvas.class.getName());
    private static final int MAXTRY = 3;
    public static final Cursor GO_CURSOR = (Cursor)UIManager.get("cursor.go");
    private final FreeColClient freeColClient;
    private final GraphicsDevice graphicsDevice;
    private boolean windowed;
    private FreeColFrame parentFrame;
    private Dimension oldSize;
    private final MapViewer mapViewer;
    private MapControls mapControls;
    private GrayLayer greyLayer;
    private final List<FreeColDialog<?>> dialogs = new ArrayList();
    private MainPanel mainPanel;
    private Scrolling scrolling;
    private CanvasMapViewer canvasMapViewer;
    private Timer animationTimer;

    public Canvas(FreeColClient freeColClient, GraphicsDevice graphicsDevice, Dimension desiredSize, MapViewer mapViewer, MapControls mapControls) {
        assert (SwingUtilities.isEventDispatchThread());
        this.freeColClient = freeColClient;
        this.graphicsDevice = graphicsDevice;
        this.canvasMapViewer = new CanvasMapViewer(freeColClient, mapViewer);
        this.scrolling = new Scrolling(freeColClient, this);
        this.windowed = Canvas.checkWindowed(graphicsDevice, desiredSize);
        Rectangle windowBounds = null;
        if (this.windowed && desiredSize != null && desiredSize.width > 0 && desiredSize.height > 0) {
            windowBounds = new Rectangle(desiredSize);
        }
        this.parentFrame = this.createFrame(null, windowBounds);
        this.oldSize = this.getSize();
        this.add((Component)this.canvasMapViewer, FRAME_CONTENT_LAYER);
        this.canvasMapViewer.setSize(this.oldSize);
        this.canvasMapViewer.setLocation(0, 0);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Canvas.this.updateSize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Canvas.this.updateSize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Canvas.this.updateSize();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Canvas.this.updateSize();
            }
        });
        this.mapViewer = mapViewer;
        this.mapControls = mapControls;
        this.greyLayer = new GrayLayer(freeColClient);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.setLayout(null);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        for (Option option : freeColClient.getActionManager().getOptions()) {
            FreeColAction action = (FreeColAction)option;
            this.getInputMap().put(action.getAccelerator(), action.getId());
            this.getActionMap().put(action.getId(), action);
        }
        this.parentFrame.setVisible(true);
        this.updateSize();
        this.revalidate();
        this.repaint();
        this.animationTimer = new Timer(125, event -> this.paintJustTheMapImmediately());
        this.animationTimer.start();
        logger.info("Canvas created with bounds: " + windowBounds);
    }

    private void updateSize() {
        Dimension size = this.getSize();
        if (this.oldSize.width != size.width || this.oldSize.height != size.height) {
            logger.info("Canvas resize from " + this.oldSize + " to " + size);
            this.oldSize = size;
            this.canvasMapViewer.changeSize(size);
            boolean add = this.removeMapControls();
            if (add) {
                this.addMapControls();
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void toggleWindowed() {
        this.windowed = !this.windowed;
    }

    private FreeColFrame createFrame(JMenuBar menuBar, Rectangle windowBounds) {
        FreeColFrame fcf = new FreeColFrame(this.freeColClient, this.graphicsDevice, menuBar, this.isWindowed(), windowBounds);
        fcf.getContentPane().add(this);
        return fcf;
    }

    private void destroyFrame() {
        if (this.parentFrame != null) {
            this.parentFrame.setVisible(false);
            if (!this.isWindowed()) {
                this.parentFrame.exitFullScreen();
            }
            this.parentFrame.dispose();
            this.parentFrame = null;
        }
    }

    private static boolean checkWindowed(GraphicsDevice gd, Dimension desiredSize) {
        boolean ret;
        if (desiredSize == null) {
            if (gd.isFullScreenSupported()) {
                logger.info("Full screen mode used.");
                ret = false;
            } else {
                logger.warning("Full screen mode not supported.");
                System.err.println(Messages.message("client.fullScreen"));
                ret = true;
            }
        } else {
            logger.info("Windowed mode used.");
            ret = true;
        }
        return ret;
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox, SwingGUI.PopupPosition popupPosition, boolean resizable) {
        int FRAME_EMPTY_SPACE = 60;
        JInternalFrame f = toolBox ? new ToolBoxFrame() : new JInternalFrame();
        Container con = f.getContentPane();
        if (con instanceof JComponent) {
            JComponent c = (JComponent)con;
            c.setOpaque(false);
            c.setBorder(null);
        }
        if (comp.getBorder() != null) {
            if (comp.getBorder() instanceof EmptyBorder) {
                f.setBorder(Utility.blankBorder(10, 10, 10, 10));
            } else {
                f.setBorder(comp.getBorder());
                comp.setBorder(Utility.blankBorder(5, 5, 5, 5));
            }
        } else {
            f.setBorder(null);
        }
        FrameMotionListener fml = new FrameMotionListener(f);
        comp.addMouseMotionListener(fml);
        comp.addMouseListener(fml);
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
            biu.setSouthPane(null);
            biu.setWestPane(null);
            biu.setEastPane(null);
        }
        f.getContentPane().add(comp);
        f.setOpaque(false);
        f.pack();
        int width = f.getWidth();
        int height = f.getHeight();
        if (width > this.getWidth() - 60) {
            width = Math.min(width, this.getWidth());
        }
        if (height > this.getHeight() - 60) {
            height = Math.min(height, this.getHeight());
        }
        f.setSize(width, height);
        Point p = this.chooseLocation(comp, width, height, popupPosition);
        f.setLocation(p);
        this.addToCanvas(f, MODAL_LAYER);
        f.setName(comp.getClass().getSimpleName());
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(resizable);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return f;
    }

    private void addCentered(Component comp, Integer layer) {
        comp.setLocation((this.oldSize.width - comp.getWidth()) / 2, (this.oldSize.height - comp.getHeight()) / 2);
        this.addToLayer(comp, layer);
    }

    private void addToLayer(Component comp, Integer layer) {
        this.addToCanvas(comp, layer);
        this.updateMenuBar();
    }

    private void addToCanvas(Component comp, Integer layer) {
        try {
            this.remove(comp);
            this.add(comp, layer);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "addToCanvas(" + comp.getClass().getSimpleName() + " at " + comp.getX() + "," + comp.getY() + " on layer " + layer + ") failed.", e);
        }
    }

    private JInternalFrame getInternalFrame(Component c) {
        Component temp;
        for (temp = c; temp != null && !(temp instanceof JInternalFrame); temp = temp.getParent()) {
        }
        return (JInternalFrame)temp;
    }

    private boolean nothingShowing() {
        return this.dialogs.isEmpty() && this.getShowingPanel() == null;
    }

    private Point chooseLocation(Component comp, int width, int height, SwingGUI.PopupPosition popupPosition) {
        Point p = null;
        if (comp instanceof FreeColPanel && (p = this.getSavedPosition(comp)) != null && (p.getX() < 0.0 || p.getX() >= (double)(this.getWidth() - width) || p.getY() < 0.0 || p.getY() >= (double)(this.getHeight() - height))) {
            p = null;
        }
        int x = 0;
        int y = 0;
        if (p != null) {
            x = (int)p.getX();
            y = (int)p.getY();
        } else if (popupPosition != null) {
            switch (popupPosition) {
                case CENTERED: {
                    x = (this.getWidth() - width) / 2;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case CENTERED_LEFT: {
                    x = (this.getWidth() - width) / 4;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case CENTERED_RIGHT: {
                    x = (this.getWidth() - width) * 3 / 4;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case ORIGIN: {
                    y = 0;
                    x = 0;
                }
            }
        }
        p = this.getClearSpace(x, y, width, height, 3);
        if (p != null && p.x >= 0 && p.x < this.getWidth() && p.y >= 0 && p.y < this.getHeight()) {
            x = p.x;
            y = p.y;
        }
        return new Point(x, y);
    }

    private Point getClearSpace(int x, int y, int w, int h, int tries) {
        Rectangle bounds = this.getBounds();
        if (!bounds.contains(x, y)) {
            return null;
        }
        tries = 3 * tries + 1;
        ArrayList<Point> todo = new ArrayList<Point>();
        Point p = new Point(x, y);
        todo.add(p);
        List<Component> allComponents = CollectionUtils.transform(this.getComponents(), c -> !(c instanceof GrayLayer) && c.isValid());
        allComponents.addAll(this.dialogs);
        int bestScore = Integer.MAX_VALUE;
        Point best = p;
        while (!todo.isEmpty()) {
            p = (Point)todo.remove(0);
            Rectangle r = new Rectangle(p.x, p.y, w, h);
            if (!bounds.contains(r)) continue;
            int foundScore = 0;
            Component found = null;
            for (Component c2 : allComponents) {
                Rectangle rr;
                int score;
                Rectangle rb = c2.getBounds();
                if (!rb.intersects(r) || foundScore >= (score = (int)Math.round((rr = rb.intersection(r)).getWidth() * rr.getHeight()))) continue;
                foundScore = score;
                found = c2;
            }
            if (found == null) {
                return p;
            }
            if (bestScore > foundScore) {
                bestScore = foundScore;
                best = p;
            }
            if (--tries <= 0) break;
            int n = todo.size();
            int x0 = found.getX() + found.getWidth() + 1;
            int y0 = found.getY() + found.getHeight() + 1;
            int x1 = bounds.x + bounds.width - w - 1;
            int y1 = bounds.y + bounds.height - h - 1;
            int x2 = bounds.x;
            int y2 = bounds.y;
            boolean x0ok = bounds.contains(x0 + w, y);
            boolean y0ok = bounds.contains(x, y0 + h);
            boolean x1ok = bounds.contains(x1, y);
            boolean y1ok = bounds.contains(x, y1);
            todo.add(n, new Point(x0ok ? x0 : (x1ok ? x1 : x2), y0ok ? y0 : (y1ok ? y1 : y2)));
            todo.add(n, new Point(x, y0ok ? y0 : (y1ok ? y1 : y2)));
            todo.add(n, new Point(x0ok ? x0 : (x1ok ? x1 : x2), y));
        }
        return best;
    }

    private Point getSavedPosition(Component comp) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return null;
        }
        try {
            if (!co.getBoolean("model.option.rememberPanelPositions")) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return co.getPanelPosition(comp.getClass().getName());
    }

    private Dimension getSavedSize(Component comp) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return null;
        }
        try {
            if (!co.getBoolean("model.option.rememberPanelSizes")) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return co.getPanelSize(comp.getClass().getName());
    }

    private void saveInteger(String className, String key, int value) {
        if (this.freeColClient == null) {
            return;
        }
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return;
        }
        OptionGroup etc = co.getOptionGroup("clientOptions.etc");
        if (etc == null) {
            return;
        }
        if (!etc.hasOption(className + key, IntegerOption.class)) {
            Specification specification = this.freeColClient.getGame() == null ? null : this.freeColClient.getGame().getSpecification();
            etc.add(new IntegerOption(className + key, specification));
        }
        etc.setInteger(className + key, value);
    }

    private void savePosition(Component comp, Point position) {
        try {
            if (!this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelPositions")) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        this.saveInteger(className, ".x", position.x);
        this.saveInteger(className, ".y", position.y);
    }

    private void saveSize(Component comp, Dimension size) {
        try {
            if (!this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelSizes")) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        this.saveInteger(className, ".w", size.width);
        this.saveInteger(className, ".h", size.height);
    }

    private void notifyClose(Component c, JInternalFrame jif) {
        if (c instanceof FreeColPanel) {
            FreeColPanel fcp = (FreeColPanel)c;
            fcp.firePropertyChange("closing", false, true);
            this.savePosition(fcp, jif.getLocation());
            this.saveSize(fcp, fcp.getSize());
            if (this.nothingShowing()) {
                this.updateMenuBar();
            }
        }
    }

    public void removeInGameComponents() {
        MouseListener[] mouseListeners;
        KeyListener[] keyListeners;
        for (KeyListener keyListener : keyListeners = this.getKeyListeners()) {
            this.removeKeyListener(keyListener);
        }
        for (MouseListener mouseListener : mouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (MouseMotionListener mouseMotionListener : mouseMotionListeners) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        for (Component c : this.getComponents()) {
            if (c instanceof CanvasMapViewer) continue;
            this.removeFromCanvas(c);
        }
    }

    public void startMapEditorGUI() {
        this.freeColClient.updateActions();
        this.parentFrame.setMenuBar(new MapEditorMenuBar(this.freeColClient, new MenuMouseMotionListener(this.scrolling)));
        CanvasMapEditorMouseListener listener = new CanvasMapEditorMouseListener(this.freeColClient, this.scrolling);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void initializeInGame() {
        this.parentFrame.setMenuBar(new InGameMenuBar(this.freeColClient, new MenuMouseMotionListener(this.scrolling)));
        this.addMouseListener(new CanvasMouseListener(this.freeColClient));
        this.addMouseMotionListener(new CanvasMouseMotionListener(this.freeColClient, this.scrolling));
    }

    public void quit() {
        this.destroyFrame();
    }

    public void restoreSavedSize(Component comp, Dimension d) {
        Dimension pref = comp.getPreferredSize();
        Dimension sugg = d == null ? pref : d;
        boolean save = false;
        Dimension size = this.getSavedSize(comp);
        if (size == null) {
            size = new Dimension(pref);
            save = true;
        }
        if (size.width < sugg.width) {
            size.width = sugg.width;
            save = true;
        }
        if (size.height < sugg.height) {
            size.height = sugg.height;
            save = true;
        }
        if (size.width < pref.width) {
            size.width = pref.width;
            save = true;
        }
        if (size.height < pref.height) {
            size.height = pref.height;
            save = true;
        }
        if (save) {
            this.saveSize(comp, size);
        }
        if (!pref.equals(size)) {
            comp.setPreferredSize(size);
        }
    }

    public void animationLabel(JLabel label, boolean add) {
        if (add) {
            this.addToCanvas(label, JLayeredPane.DEFAULT_LAYER);
        } else {
            this.removeFromCanvas(label);
        }
    }

    public void closePanel(String panel) {
        block4: {
            block3: {
                if (!panel.endsWith("Panel")) break block3;
                for (Component c1 : this.getComponents()) {
                    if (!(c1 instanceof JInternalFrame)) continue;
                    for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                        if (!panel.equals(c2.getClass().getName())) continue;
                        this.notifyClose(c2, (JInternalFrame)c1);
                        return;
                    }
                }
                break block4;
            }
            if (!panel.endsWith("Dialog")) break block4;
            for (FreeColDialog<?> fcd : new ArrayList(this.dialogs)) {
                if (!panel.equals(fcd.getClass().getName())) continue;
                this.dialogs.remove(fcd);
                fcd.dispose();
                return;
            }
        }
    }

    public void dialogAdd(FreeColDialog<?> fcd) {
        if (fcd.isModal()) {
            this.mapViewer.getMapViewerState().setCursorBlinking(false);
        }
        this.dialogs.add(fcd);
    }

    public void dialogRemove(FreeColDialog<?> fcd) {
        this.dialogs.remove(fcd);
        if (fcd.isModal() && CollectionUtils.none(this.dialogs, FreeColDialog::isModal)) {
            this.mapViewer.getMapViewerState().setCursorBlinking(true);
        }
        if (this.nothingShowing()) {
            this.updateMenuBar();
        }
    }

    public FreeColDialog<?> getExistingFreeColDialog(Class<?> type) {
        for (FreeColDialog<?> d : this.dialogs) {
            if (d.getClass() != type) continue;
            return d;
        }
        return null;
    }

    public <T extends FreeColPanel> T getExistingFreeColPanel(Class<T> type) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                try {
                    FreeColPanel ret = (FreeColPanel)type.cast(c2);
                    if (ret == null) continue;
                    JInternalFrame jif = (JInternalFrame)c1;
                    SwingUtilities.invokeLater(() -> {
                        jif.toFront();
                        jif.repaint();
                    });
                    return (T)ret;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Component getMatchingComponent(Predicate<Component> pred) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                if (!pred.test(c2)) continue;
                return c2;
            }
        }
        return null;
    }

    public Component getShowingPanel() {
        for (Component c : this.getComponents()) {
            if (c instanceof ToolBoxFrame) continue;
            if (c instanceof JInternalFrame) {
                return c;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            return c;
        }
        return null;
    }

    public void removeFromCanvas(Component comp) {
        if (comp == null) {
            return;
        }
        Rectangle updateBounds = comp.getBounds();
        JInternalFrame jif = this.getInternalFrame(comp);
        if (jif != null && jif != comp) {
            jif.dispose();
        } else {
            try {
                super.remove(comp);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Java crash", e);
            }
        }
        if (jif != null) {
            this.notifyClose(comp, jif);
        }
        this.repaint(updateBounds.x, updateBounds.y, updateBounds.width, updateBounds.height);
    }

    public <T> T showFreeColDialog(FreeColDialog<T> dialog, SwingGUI.PopupPosition pos) {
        this.viewFreeColDialog(dialog, pos);
        T response = dialog.getResponse();
        this.remove(dialog);
        this.dialogRemove(dialog);
        return response;
    }

    public FreeColPanel showFreeColPanel(FreeColPanel panel, SwingGUI.PopupPosition popupPosition, boolean resizable) {
        this.repaint();
        this.addAsFrame(panel, false, popupPosition, resizable);
        panel.requestFocus();
        this.freeColClient.getActionManager().update();
        return panel;
    }

    public <T> void viewFreeColDialog(FreeColDialog<T> freeColDialog, SwingGUI.PopupPosition pos) {
        if (!freeColDialog.isModal()) {
            int canvasWidth = this.getWidth();
            int dialogWidth = freeColDialog.getWidth();
            if (dialogWidth * 2 <= canvasWidth) {
                Point location = freeColDialog.getLocation();
                if (pos == SwingGUI.PopupPosition.CENTERED_LEFT) {
                    freeColDialog.setLocation(location.x - canvasWidth / 4, location.y);
                } else if (pos == SwingGUI.PopupPosition.CENTERED_RIGHT) {
                    freeColDialog.setLocation(location.x + canvasWidth / 4, location.y);
                }
            }
        }
        this.dialogAdd(freeColDialog);
        freeColDialog.requestFocus();
        freeColDialog.setVisible(true);
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public FreeColFrame getParentFrame() {
        return this.parentFrame;
    }

    public void toggleFrame() {
        JMenuBar menuBar = null;
        Rectangle windowBounds = null;
        if (this.parentFrame != null) {
            menuBar = this.parentFrame.getJMenuBar();
            windowBounds = this.parentFrame.getBounds();
        }
        this.destroyFrame();
        this.toggleWindowed();
        this.parentFrame = this.createFrame(menuBar, windowBounds);
        this.parentFrame.setVisible(true);
    }

    public boolean addMapControls() {
        if (this.mapControls == null) {
            return false;
        }
        List<Component> components = this.mapControls.getComponentsToAdd(this.oldSize);
        for (Component c : components) {
            this.addToCanvas(c, JLayeredPane.MODAL_LAYER);
        }
        return !components.isEmpty();
    }

    public boolean removeMapControls() {
        if (this.mapControls == null) {
            return false;
        }
        List<Component> components = this.mapControls.getComponentsPresent();
        boolean ret = false;
        for (Component c : this.mapControls.getComponentsPresent()) {
            this.removeFromCanvas(c);
            ret = true;
        }
        return ret;
    }

    public void closeMenus() {
        for (JInternalFrame jif : this.getAllFrames()) {
            for (Component c : jif.getContentPane().getComponents()) {
                this.notifyClose(c, jif);
            }
            jif.dispose();
        }
        while (!this.dialogs.isEmpty()) {
            FreeColDialog<?> dialog = this.dialogs.remove(0);
            dialog.dispose();
        }
    }

    public void resetMenuBar() {
        this.freeColClient.updateActions();
        this.parentFrame.resetMenuBar();
    }

    public void updateMenuBar() {
        this.freeColClient.updateActions();
        this.parentFrame.updateMenuBar();
    }

    public void playVideo(String videoId, boolean muteAudio, final Runnable runnable) {
        Video video = ImageLibrary.getVideo(videoId);
        if (video == null) {
            runnable.run();
            return;
        }
        final String originalVendor = System.getProperty("java.vendor");
        if (originalVendor.indexOf(" ") == -1) {
            System.setProperty("java.vendor", originalVendor + " cortadoBugFix");
        }
        final VideoComponent vc = new VideoComponent(video, muteAudio, this.getSize());
        this.closeMenus();
        final class AbortListener
        implements ActionListener,
        KeyListener,
        MouseListener,
        VideoListener {
            private Timer t = null;

            AbortListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e1) {
                this.execute();
            }

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void mouseClicked(MouseEvent e3) {
                this.execute();
            }

            @Override
            public void mouseEntered(MouseEvent e4) {
            }

            @Override
            public void mouseExited(MouseEvent e5) {
            }

            @Override
            public void mousePressed(MouseEvent e6) {
            }

            @Override
            public void mouseReleased(MouseEvent e7) {
            }

            @Override
            public void stopped() {
                this.execute();
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.execute();
            }

            public void startTimer(int tim) {
                this.t = new Timer(tim, this);
                this.t.setRepeats(false);
                this.t.start();
            }

            private void execute() {
                Canvas.this.removeKeyListener(this);
                Canvas.this.removeMouseListener(this);
                vc.removeMouseListener(this);
                vc.stop();
                Canvas.this.remove(vc);
                if (this.t != null) {
                    this.t.stop();
                }
                System.setProperty("java.vendor", originalVendor);
                runnable.run();
            }
        }
        AbortListener l = new AbortListener();
        this.addMouseListener(l);
        this.addKeyListener(l);
        vc.addMouseListener(l);
        vc.addKeyListener(l);
        l.startTimer(80000);
        this.addCentered(vc, JLayeredPane.PALETTE_LAYER);
        vc.play();
    }

    public void closeMainPanel() {
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
            this.mainPanel = null;
        }
    }

    public void mainTitle() {
        this.showMainPanel();
        this.revalidate();
        this.repaint();
    }

    void mainTitleIfMainPanelIsAlreadyShowing() {
        if (this.mainPanel != null && this.mainPanel.isShowing()) {
            this.mainTitle();
        }
    }

    public FreeColPanel showMainPanel() {
        this.prepareShowingMainMenu();
        this.mainPanel = new MainPanel(this.freeColClient);
        this.addAsFrame(this.mainPanel, false, SwingGUI.PopupPosition.CENTERED, false);
        this.mainPanel.requestFocus();
        return this.mainPanel;
    }

    public void prepareShowingMainMenu() {
        this.removeInGameComponents();
        this.closeMenus();
        this.closeMainPanel();
        this.parentFrame.removeMenuBar();
    }

    public void showMapEditorTransformPanel() {
        MapEditorTransformPanel panel = new MapEditorTransformPanel(this.freeColClient);
        JInternalFrame f = this.addAsFrame(panel, true, SwingGUI.PopupPosition.CENTERED, false);
        f.setLocation(f.getX(), 50);
        this.repaint();
    }

    public void paintJustTheMapImmediately() {
        if (this.freeColClient == null || this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        this.canvasMapViewer.paintImmediately();
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean hasMap;
        super.paintComponent(g);
        if (!this.freeColClient.isInGame()) {
            return;
        }
        boolean bl = hasMap = this.freeColClient != null && this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null;
        if (hasMap) {
            Dimension size = this.getSize();
            if (this.freeColClient.currentPlayerIsMyPlayer()) {
                if (this.greyLayer.getParent() != null) {
                    this.removeFromCanvas(this.greyLayer);
                }
            } else {
                this.greyLayer.setBounds(0, 0, size.width, size.height);
                this.greyLayer.setPlayer(this.freeColClient.getGame().getCurrentPlayer());
                if (this.greyLayer.getParent() == null) {
                    this.addToCanvas(this.greyLayer, JLayeredPane.DRAG_LAYER);
                }
            }
        }
    }

    @Override
    public void remove(Component comp) {
        this.removeFromCanvas(comp);
    }

    private static class ToolBoxFrame
    extends JInternalFrame {
        private ToolBoxFrame() {
        }
    }
}

