/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners;

import java.io.Writer;

class PrefixedWriter
extends Writer {
    private static final char LF = '\n';
    private final Writer sink;
    private final String prefix;
    private final StringBuilder lineBuffer = new StringBuilder();
    private final int maxLineLength;

    public PrefixedWriter(String string, Writer writer, int n) {
        super((Object)writer);
        this.sink = writer;
        this.prefix = string;
        this.maxLineLength = n;
    }

    @Override
    public void write(int n) {
        if (this.lineBuffer.length() == this.maxLineLength || n == 10) {
            this.sink.write(this.prefix);
            this.sink.write(this.lineBuffer.toString());
            this.sink.write(10);
            this.lineBuffer.setLength(0);
            if (n != 10) {
                this.lineBuffer.append((char)n);
            }
        } else {
            this.lineBuffer.append((char)n);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.write(cArray[i]);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    public void completeLine() {
        if (this.lineBuffer.length() > 0) {
            this.write(10);
        }
    }
}

