/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class JavaToSQLValueNode
extends ValueNode {
    JavaValueNode javaNode;

    public void init(Object object) {
        this.javaNode = (JavaValueNode)object;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.javaNode.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        LocalField localField;
        Object object;
        this.javaNode.returnValueToSQLDomain();
        boolean bl = this.javaNode.generateReceiver(expressionClassBuilder, methodBuilder);
        if (bl) {
            object = this.getTypeCompiler().interfaceName();
            localField = expressionClassBuilder.newFieldDeclaration(2, (String)object);
            methodBuilder.conditionalIfNull();
            methodBuilder.getField(localField);
            expressionClassBuilder.generateNullWithExpress(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
            methodBuilder.startElseCode();
        }
        TypeId typeId = this.getTypeId();
        object = this.getTypeCompiler();
        String string = object.interfaceName();
        localField = expressionClassBuilder.newFieldDeclaration(2, string);
        this.javaNode.generateExpression(expressionClassBuilder, methodBuilder);
        expressionClassBuilder.generateDataValue(methodBuilder, (TypeCompiler)object, this.getTypeServices().getCollationType(), localField);
        if (bl) {
            methodBuilder.completeConditional();
        }
    }

    public void printSubNodes(int n) {
    }

    public JavaValueNode getJavaValueNode() {
        return this.javaNode;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.javaNode.checkReliability(this);
        this.javaNode = this.javaNode.bindExpression(fromList, subqueryList, vector);
        DataTypeDescriptor dataTypeDescriptor = this.javaNode.getDataType();
        if (dataTypeDescriptor == null) {
            throw StandardException.newException("X0X57.S", this.javaNode.getJavaTypeName());
        }
        TypeDescriptor typeDescriptor = dataTypeDescriptor.getCatalogType();
        if (typeDescriptor.isRowMultiSet() || typeDescriptor.getTypeName().equals("java.sql.ResultSet")) {
            throw StandardException.newException("42ZB6");
        }
        this.setType(dataTypeDescriptor);
        if (dataTypeDescriptor.getTypeId().isStringTypeId()) {
            this.setCollationInfo(this.javaNode.getCollationType(), 1);
        }
        return this;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.javaNode = this.javaNode.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.javaNode.categorize(jBitSet, bl);
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.javaNode.getOrderableVariantType();
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.javaNode != null) {
            this.javaNode = (JavaValueNode)this.javaNode.accept(visitor);
        }
    }

    protected boolean isEquivalent(ValueNode valueNode) {
        return false;
    }
}

