"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wizardSavedObjectType = void 0;

var _common = require("../../common");

var _wizard_migration = require("./wizard_migration");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const wizardSavedObjectType = {
  name: _common.WIZARD_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    // icon: '', // TODO: Need a custom icon here - unfortunately a custom SVG won't work without changes to the SavedObjectsManagement plugin
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle: ({
      attributes: {
        title
      }
    }) => title,
    getEditUrl: ({
      id
    }) => `/management/opensearch-dashboards/objects/savedWizard/${encodeURIComponent(id)}`,

    getInAppUrl({
      id
    }) {
      return {
        path: `/app/${_common.PLUGIN_ID}${_common.EDIT_PATH}/${encodeURIComponent(id)}`,
        uiCapabilitiesPath: 'wizard.show'
      };
    }

  },
  migrations: _wizard_migration.wizardSavedObjectTypeMigrations,
  mappings: {
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      visualizationState: {
        type: 'text',
        index: false
      },
      styleState: {
        type: 'text',
        index: false
      },
      version: {
        type: 'integer'
      },
      // Need to add a kibanaSavedObjectMeta attribute here to follow the current saved object flow
      // When we save a saved object, the saved object plugin will extract the search source into two parts
      // Some information will be put into kibanaSavedObjectMeta while others will be created as a reference object and pushed to the reference array
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text',
            index: false
          }
        }
      }
    }
  }
};
exports.wizardSavedObjectType = wizardSavedObjectType;