"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("core-js/modules/es.typed-array.set.js");

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat) => {
      try {
        const queryRequest = {
          query: request.body
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.error(err);
        return {
          data: {
            ok: false,
            resp: err.response,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryInternal(request, 'ppl.sqlQuery', 'json');
    });

    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryInternal(request, 'ppl.pplQuery', 'json');
    });

    this.client = client;
  }

}

exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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