"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSqlRoute = registerSqlRoute;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerSqlRoute(server, service) {
  server.post({
    path: '/api/sql/sqlquery',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: '/api/sql/pplquery',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(request);
    return response.ok({
      body: retVal
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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