"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./types");
exports.DEFAULT_POPPER_SETTINGS = {
    fallbackPlacements: [types_1.Placement.Right, types_1.Placement.Left, types_1.Placement.Top, types_1.Placement.Bottom],
    placement: types_1.Placement.Right,
    offset: 10,
};
function getOrCreateNode(id, className, parent) {
    if (parent === void 0) { parent = document.body; }
    var node = document.getElementById(id);
    if (node) {
        return node;
    }
    var newNode = document.createElement('div');
    newNode.id = id;
    if (className) {
        newNode.classList.add(className);
    }
    parent.appendChild(newNode);
    return newNode;
}
exports.getOrCreateNode = getOrCreateNode;
function isHTMLElement(value) {
    return typeof value === 'object' && value !== null && value.hasOwnProperty('nodeName');
}
exports.isHTMLElement = isHTMLElement;
//# sourceMappingURL=utils.js.map