/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.PathSearchingVirtualMachine;
import java.util.Iterator;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.command.DebugProcessCommand;

public class GetPathInfo
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (!(this.m_debugger.getVM() instanceof PathSearchingVirtualMachine)) {
            throw new JDEException("VM doesn't search paths");
        }
        PathSearchingVirtualMachine vm = (PathSearchingVirtualMachine)this.m_debugger.getVM();
        StringBuffer bootClassPathString = new StringBuffer("(list");
        Iterator<String> it = vm.bootClassPath().iterator();
        while (it.hasNext()) {
            bootClassPathString.append(" \"");
            bootClassPathString.append((Object)it.next());
            bootClassPathString.append("\"");
        }
        bootClassPathString.append(")");
        String bcpRes = bootClassPathString.toString().replace('\\', '/');
        StringBuffer classPathString = new StringBuffer("(list");
        it = vm.classPath().iterator();
        while (it.hasNext()) {
            classPathString.append(" \"");
            classPathString.append((Object)it.next());
            classPathString.append("\"");
        }
        classPathString.append(")");
        String cpRes = classPathString.toString().replace('\\', '/');
        this.m_debugger.signalCommandResult(this.m_cmdID, "\"" + vm.baseDirectory().replace('\\', '/') + "\"" + Protocol.BR + bootClassPathString + Protocol.BR + classPathString, true, false);
    }

    public Object clone() {
        return new GetPathInfo();
    }
}

