/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.Pattern;

class SequencePattern
extends Pattern {
    private final Pattern[] patterns;

    SequencePattern(Pattern ... patterns) {
        this.patterns = patterns;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        int current = begin;
        for (Pattern pattern : this.patterns) {
            int l = pattern.match(src, current, end);
            if (l == -1) {
                return l;
            }
            current += l;
        }
        return current - begin;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Pattern pattern : this.patterns) {
            sb.append(pattern);
        }
        return sb.toString();
    }
}

