/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.jxls.area.Area;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.formula.FormulaProcessor;
import org.jxls.formula.StandardFormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.util.TransformerFactory;
import org.traccar.api.security.PermissionsService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.geocoder.Geocoder;
import org.traccar.handler.events.MotionEventHandler;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.PositionUtil;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Event;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.Position;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.reports.common.TripsConfig;
import org.traccar.reports.model.BaseReportItem;
import org.traccar.reports.model.StopReportItem;
import org.traccar.reports.model.TripReportItem;
import org.traccar.session.DeviceState;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class ReportUtils {
    private final Config config;
    private final Storage storage;
    private final PermissionsService permissionsService;
    private final TripsConfig tripsConfig;
    private final VelocityEngine velocityEngine;
    private final Geocoder geocoder;

    @Inject
    public ReportUtils(Config config, Storage storage, PermissionsService permissionsService, TripsConfig tripsConfig, VelocityEngine velocityEngine, @Nullable Geocoder geocoder) {
        this.config = config;
        this.storage = storage;
        this.permissionsService = permissionsService;
        this.tripsConfig = tripsConfig;
        this.velocityEngine = velocityEngine;
        this.geocoder = geocoder;
    }

    public <T extends BaseModel> T getObject(long userId, Class<T> clazz, long objectId) throws StorageException, SecurityException {
        return (T)((BaseModel)this.storage.getObject(clazz, new Request(new Columns.Include("id"), new Condition.And(new Condition.Equals("id", "id", objectId), new Condition.Permission(User.class, userId, clazz)))));
    }

    public void checkPeriodLimit(Date from, Date to) {
        long limit = this.config.getLong(Keys.REPORT_PERIOD_LIMIT) * 1000L;
        if (limit > 0L && to.getTime() - from.getTime() > limit) {
            throw new IllegalArgumentException("Time period exceeds the limit");
        }
    }

    public Collection<Device> getAccessibleDevices(long userId, Collection<Long> deviceIds, Collection<Long> groupIds) throws StorageException {
        List<Device> devices = this.storage.getObjects(Device.class, new Request(new Columns.All(), new Condition.Permission(User.class, userId, Device.class)));
        Map<Long, Device> deviceById = devices.stream().collect(Collectors.toUnmodifiableMap(BaseModel::getId, x -> x));
        Map<Long, List<Device>> devicesByGroup = devices.stream().filter(x -> x.getGroupId() > 0L).collect(Collectors.groupingBy(GroupedModel::getGroupId));
        List<Group> groups = this.storage.getObjects(Group.class, new Request(new Columns.All(), new Condition.Permission(User.class, userId, Group.class)));
        Map<Long, List<Group>> groupsByGroup = groups.stream().filter(x -> x.getGroupId() > 0L).collect(Collectors.groupingBy(GroupedModel::getGroupId));
        Set<Device> results = deviceIds.stream().map(deviceById::get).filter(Objects::nonNull).collect(Collectors.toSet());
        LinkedList<Long> groupQueue = new LinkedList<Long>(groupIds);
        while (!groupQueue.isEmpty()) {
            long groupId = groupQueue.pop();
            results.addAll(devicesByGroup.getOrDefault(groupId, Collections.emptyList()));
            groupQueue.addAll(groupsByGroup.getOrDefault(groupId, Collections.emptyList()).stream().map(BaseModel::getId).collect(Collectors.toUnmodifiableList()));
        }
        return results;
    }

    public double calculateFuel(Position firstPosition, Position lastPosition) {
        if (firstPosition.getAttributes().get("fuel") != null && lastPosition.getAttributes().get("fuel") != null) {
            BigDecimal value = BigDecimal.valueOf(firstPosition.getDouble("fuel") - lastPosition.getDouble("fuel"));
            return value.setScale(1, RoundingMode.HALF_EVEN).doubleValue();
        }
        return 0.0;
    }

    public String findDriver(Position firstPosition, Position lastPosition) {
        if (firstPosition.hasAttribute("driverUniqueId")) {
            return firstPosition.getString("driverUniqueId");
        }
        if (lastPosition.hasAttribute("driverUniqueId")) {
            return lastPosition.getString("driverUniqueId");
        }
        return null;
    }

    public String findDriverName(String driverUniqueId) throws StorageException {
        Driver driver;
        if (driverUniqueId != null && (driver = this.storage.getObject(Driver.class, new Request(new Columns.All(), new Condition.Equals("uniqueId", "uniqueId", driverUniqueId)))) != null) {
            return driver.getName();
        }
        return null;
    }

    public Context initializeContext(long userId) throws StorageException {
        Server server = this.permissionsService.getServer();
        User user = this.permissionsService.getUser(userId);
        Context context = PoiTransformer.createInitialContext();
        context.putVar("distanceUnit", (Object)UserUtil.getDistanceUnit(server, user));
        context.putVar("speedUnit", (Object)UserUtil.getSpeedUnit(server, user));
        context.putVar("volumeUnit", (Object)UserUtil.getVolumeUnit(server, user));
        context.putVar("webUrl", this.velocityEngine.getProperty("web.url"));
        context.putVar("dateTool", (Object)new DateTool());
        context.putVar("numberTool", (Object)new NumberTool());
        context.putVar("timezone", (Object)UserUtil.getTimezone(server, user));
        context.putVar("locale", (Object)Locale.getDefault());
        context.putVar("bracketsRegex", (Object)"[\\{\\}\"]");
        return context;
    }

    public void processTemplateWithSheets(InputStream templateStream, OutputStream targetStream, Context context) throws IOException {
        Transformer transformer = TransformerFactory.createTransformer((InputStream)templateStream, (OutputStream)targetStream);
        List xlsAreas = new XlsCommentAreaBuilder(transformer).build();
        for (Area xlsArea : xlsAreas) {
            xlsArea.applyAt(new CellRef(xlsArea.getStartCellRef().getCellName()), context);
            xlsArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
            xlsArea.processFormulas();
        }
        transformer.deleteSheet(((Area)xlsAreas.get(0)).getStartCellRef().getSheetName());
        transformer.write();
    }

    private TripReportItem calculateTrip(Device device, ArrayList<Position> positions, int startIndex, int endIndex, boolean ignoreOdometer) throws StorageException {
        Position startTrip = positions.get(startIndex);
        Position endTrip = positions.get(endIndex);
        double speedMax = 0.0;
        for (int i = startIndex; i <= endIndex; ++i) {
            double speed = positions.get(i).getSpeed();
            if (!(speed > speedMax)) continue;
            speedMax = speed;
        }
        TripReportItem trip = new TripReportItem();
        long tripDuration = endTrip.getFixTime().getTime() - startTrip.getFixTime().getTime();
        long deviceId = startTrip.getDeviceId();
        trip.setDeviceId(deviceId);
        trip.setDeviceName(device.getName());
        trip.setStartPositionId(startTrip.getId());
        trip.setStartLat(startTrip.getLatitude());
        trip.setStartLon(startTrip.getLongitude());
        trip.setStartTime(startTrip.getFixTime());
        String startAddress = startTrip.getAddress();
        if (startAddress == null && this.geocoder != null && this.config.getBoolean(Keys.GEOCODER_ON_REQUEST)) {
            startAddress = this.geocoder.getAddress(startTrip.getLatitude(), startTrip.getLongitude(), null);
        }
        trip.setStartAddress(startAddress);
        trip.setEndPositionId(endTrip.getId());
        trip.setEndLat(endTrip.getLatitude());
        trip.setEndLon(endTrip.getLongitude());
        trip.setEndTime(endTrip.getFixTime());
        String endAddress = endTrip.getAddress();
        if (endAddress == null && this.geocoder != null && this.config.getBoolean(Keys.GEOCODER_ON_REQUEST)) {
            endAddress = this.geocoder.getAddress(endTrip.getLatitude(), endTrip.getLongitude(), null);
        }
        trip.setEndAddress(endAddress);
        trip.setDistance(PositionUtil.calculateDistance(startTrip, endTrip, !ignoreOdometer));
        trip.setDuration(tripDuration);
        if (tripDuration > 0L) {
            trip.setAverageSpeed(UnitsConverter.knotsFromMps(trip.getDistance() * 1000.0 / (double)tripDuration));
        }
        trip.setMaxSpeed(speedMax);
        trip.setSpentFuel(this.calculateFuel(startTrip, endTrip));
        trip.setDriverUniqueId(this.findDriver(startTrip, endTrip));
        trip.setDriverName(this.findDriverName(trip.getDriverUniqueId()));
        if (!ignoreOdometer && startTrip.getDouble("odometer") != 0.0 && endTrip.getDouble("odometer") != 0.0) {
            trip.setStartOdometer(startTrip.getDouble("odometer"));
            trip.setEndOdometer(endTrip.getDouble("odometer"));
        } else {
            trip.setStartOdometer(startTrip.getDouble("totalDistance"));
            trip.setEndOdometer(endTrip.getDouble("totalDistance"));
        }
        return trip;
    }

    private StopReportItem calculateStop(Device device, ArrayList<Position> positions, int startIndex, int endIndex, boolean ignoreOdometer) {
        Position startStop = positions.get(startIndex);
        Position endStop = positions.get(endIndex);
        StopReportItem stop = new StopReportItem();
        long deviceId = startStop.getDeviceId();
        stop.setDeviceId(deviceId);
        stop.setDeviceName(device.getName());
        stop.setPositionId(startStop.getId());
        stop.setLatitude(startStop.getLatitude());
        stop.setLongitude(startStop.getLongitude());
        stop.setStartTime(startStop.getFixTime());
        String address = startStop.getAddress();
        if (address == null && this.geocoder != null && this.config.getBoolean(Keys.GEOCODER_ON_REQUEST)) {
            address = this.geocoder.getAddress(stop.getLatitude(), stop.getLongitude(), null);
        }
        stop.setAddress(address);
        stop.setEndTime(endStop.getFixTime());
        long stopDuration = endStop.getFixTime().getTime() - startStop.getFixTime().getTime();
        stop.setDuration(stopDuration);
        stop.setSpentFuel(this.calculateFuel(startStop, endStop));
        if (startStop.hasAttribute("hours") && endStop.hasAttribute("hours")) {
            stop.setEngineHours(endStop.getLong("hours") - startStop.getLong("hours"));
        }
        if (!ignoreOdometer && startStop.getDouble("odometer") != 0.0 && endStop.getDouble("odometer") != 0.0) {
            stop.setStartOdometer(startStop.getDouble("odometer"));
            stop.setEndOdometer(endStop.getDouble("odometer"));
        } else {
            stop.setStartOdometer(startStop.getDouble("totalDistance"));
            stop.setEndOdometer(endStop.getDouble("totalDistance"));
        }
        return stop;
    }

    private <T extends BaseReportItem> T calculateTripOrStop(Device device, ArrayList<Position> positions, int startIndex, int endIndex, boolean ignoreOdometer, Class<T> reportClass) throws StorageException {
        if (reportClass.equals(TripReportItem.class)) {
            return (T)this.calculateTrip(device, positions, startIndex, endIndex, ignoreOdometer);
        }
        return (T)this.calculateStop(device, positions, startIndex, endIndex, ignoreOdometer);
    }

    private boolean isMoving(ArrayList<Position> positions, int index, TripsConfig tripsConfig) {
        if (tripsConfig.getMinimalNoDataDuration() > 0L) {
            boolean afterGap;
            boolean beforeGap = index < positions.size() - 1 && positions.get(index + 1).getFixTime().getTime() - positions.get(index).getFixTime().getTime() >= tripsConfig.getMinimalNoDataDuration();
            boolean bl = afterGap = index > 0 && positions.get(index).getFixTime().getTime() - positions.get(index - 1).getFixTime().getTime() >= tripsConfig.getMinimalNoDataDuration();
            if (beforeGap || afterGap) {
                return false;
            }
        }
        return positions.get(index).getBoolean("motion");
    }

    public <T extends BaseReportItem> Collection<T> detectTripsAndStops(Device device, Collection<Position> positionCollection, boolean ignoreOdometer, Class<T> reportClass) throws StorageException {
        ArrayList<T> result = new ArrayList<T>();
        ArrayList<Position> positions = new ArrayList<Position>(positionCollection);
        if (!positions.isEmpty()) {
            boolean trips = reportClass.equals(TripReportItem.class);
            MotionEventHandler motionHandler = new MotionEventHandler(null, null, this.tripsConfig);
            DeviceState deviceState = new DeviceState();
            deviceState.setMotionState(this.isMoving(positions, 0, this.tripsConfig));
            int startEventIndex = trips == deviceState.getMotionState() ? 0 : -1;
            int startNoEventIndex = -1;
            for (int i = 0; i < positions.size(); ++i) {
                Map<Event, Position> event = motionHandler.updateMotionState(deviceState, positions.get(i), this.isMoving(positions, i, this.tripsConfig));
                if (startEventIndex == -1 && (trips != deviceState.getMotionState() && deviceState.getMotionPosition() != null || trips == deviceState.getMotionState() && event != null)) {
                    startEventIndex = i;
                    startNoEventIndex = -1;
                } else if (trips != deviceState.getMotionState() && startEventIndex != -1 && deviceState.getMotionPosition() == null && event == null) {
                    startEventIndex = -1;
                }
                if (startNoEventIndex == -1 && (trips == deviceState.getMotionState() && deviceState.getMotionPosition() != null || trips != deviceState.getMotionState() && event != null)) {
                    startNoEventIndex = i;
                } else if (startNoEventIndex != -1 && deviceState.getMotionPosition() == null && event == null) {
                    startNoEventIndex = -1;
                }
                if (startEventIndex == -1 || startNoEventIndex == -1 || event == null || trips == deviceState.getMotionState()) continue;
                result.add(this.calculateTripOrStop(device, positions, startEventIndex, startNoEventIndex, ignoreOdometer, reportClass));
                startEventIndex = -1;
            }
            if (!(startEventIndex == -1 || startNoEventIndex == -1 && trips)) {
                int endIndex = startNoEventIndex != -1 ? startNoEventIndex : positions.size() - 1;
                result.add(this.calculateTripOrStop(device, positions, startEventIndex, endIndex, ignoreOdometer, reportClass));
            }
        }
        return result;
    }
}

