/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import org.traccar.BasePipelineFactory;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;
import org.traccar.protocol.SuntechProtocolDecoder;

public class SuntechProtocolEncoder
extends StringProtocolEncoder {
    public SuntechProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        SuntechProtocolDecoder protocolDecoder;
        boolean universal = false;
        String prefix = "SA200";
        if (channel != null && (protocolDecoder = BasePipelineFactory.getHandler(channel.pipeline(), SuntechProtocolDecoder.class)) != null) {
            universal = protocolDecoder.getUniversal();
            String decoderPrefix = protocolDecoder.getPrefix();
            if (decoderPrefix != null && decoderPrefix.length() > 5) {
                prefix = decoderPrefix.substring(0, decoderPrefix.length() - 3);
            }
        }
        if (universal) {
            return this.encodeUniversalCommand(channel, command);
        }
        return this.encodeLegacyCommand(channel, prefix, command);
    }

    protected Object encodeUniversalCommand(Channel channel, Command command) {
        switch (command.getType()) {
            case "rebootDevice": {
                return this.formatCommand(command, "CMD;%s;03;03\r", "uniqueId");
            }
            case "positionSingle": {
                return this.formatCommand(command, "CMD;%s;03;01\r", "uniqueId");
            }
            case "outputControl": {
                if (command.getAttributes().get("data").equals("1")) {
                    switch (command.getString("index")) {
                        case "1": {
                            return this.formatCommand(command, "CMD;%s;04;01\r", "uniqueId");
                        }
                        case "2": {
                            return this.formatCommand(command, "CMD;%s;04;03\r", "uniqueId");
                        }
                        case "3": {
                            return this.formatCommand(command, "CMD;%s;04;09\r", "uniqueId");
                        }
                    }
                    return null;
                }
                switch (command.getString("index")) {
                    case "1": {
                        return this.formatCommand(command, "CMD;%s;04;02\r", "uniqueId");
                    }
                    case "2": {
                        return this.formatCommand(command, "CMD;%s;04;04\r", "uniqueId");
                    }
                    case "3": {
                        return this.formatCommand(command, "CMD;%s;04;10\r", "uniqueId");
                    }
                }
                return null;
            }
            case "engineStop": {
                return this.formatCommand(command, "CMD;%s;04;01\r", "uniqueId");
            }
            case "engineResume": {
                return this.formatCommand(command, "CMD;%s;02;02\r", "uniqueId");
            }
            case "alarmArm": {
                return this.formatCommand(command, "CMD;%s;04;03\r", "uniqueId");
            }
            case "alarmDisarm": {
                return this.formatCommand(command, "CMD;%s;04;04\r", "uniqueId");
            }
        }
        return null;
    }

    protected Object encodeLegacyCommand(Channel channel, String prefix, Command command) {
        switch (command.getType()) {
            case "rebootDevice": {
                return this.formatCommand(command, prefix + "CMD;%s;02;Reboot\r", "uniqueId");
            }
            case "positionSingle": {
                return this.formatCommand(command, prefix + "CMD;%s;02;\r", "uniqueId");
            }
            case "outputControl": {
                if (command.getAttributes().get("data").equals("1")) {
                    return this.formatCommand(command, prefix + "CMD;%s;02;Enable%s\r", "uniqueId", "index");
                }
                return this.formatCommand(command, prefix + "CMD;%s;02;Disable%s\r", "uniqueId", "index");
            }
            case "engineStop": {
                return this.formatCommand(command, prefix + "CMD;%s;02;Enable1\r", "uniqueId");
            }
            case "engineResume": {
                return this.formatCommand(command, prefix + "CMD;%s;02;Disable1\r", "uniqueId");
            }
            case "alarmArm": {
                return this.formatCommand(command, prefix + "CMD;%s;02;Enable2\r", "uniqueId");
            }
            case "alarmDisarm": {
                return this.formatCommand(command, prefix + "CMD;%s;02;Disable2\r", "uniqueId");
            }
        }
        return null;
    }
}

