/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.netbeans.api.visual.anchor.AnchorShape;

public class TriangleAnchorShape
implements AnchorShape {
    public static final Stroke STROKE = new BasicStroke(1.0f, 1, 1);
    private int size;
    private boolean filled;
    private boolean hollow;
    private double cutDistance;
    private GeneralPath generalPath;

    public TriangleAnchorShape(int n, boolean bl, boolean bl2, boolean bl3, double d) {
        this.size = n;
        this.filled = bl;
        this.hollow = bl3;
        this.cutDistance = d;
        float f = (float)n * 0.3f;
        this.generalPath = new GeneralPath();
        if (bl2) {
            this.generalPath.moveTo(n, 0.0f);
            this.generalPath.lineTo(0.0f, -f);
            this.generalPath.lineTo(0.0f, f);
            if (bl3) {
                this.generalPath.lineTo(n, 0.0f);
            }
        } else {
            this.generalPath.moveTo(0.0f, 0.0f);
            this.generalPath.lineTo(n, -f);
            this.generalPath.lineTo(n, f);
            if (bl3) {
                this.generalPath.lineTo(0.0f, 0.0f);
            }
        }
    }

    public boolean isLineOriented() {
        return true;
    }

    public int getRadius() {
        return (int)Math.ceil(1.5f * (float)this.size);
    }

    public double getCutDistance() {
        return this.cutDistance;
    }

    public void paint(Graphics2D graphics2D, boolean bl) {
        if (this.filled) {
            graphics2D.fill(this.generalPath);
        } else {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(STROKE);
            graphics2D.draw(this.generalPath);
            graphics2D.setStroke(stroke);
        }
    }
}

