/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.MetalEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.awt.HtmlRenderer;

public final class MetalViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_LEFT_PAD = 5;
    private static final int ICON_X_RIGHT_PAD = 2;
    private static final int BUMP_X_PAD = 5;
    private static final int BUMP_Y_PAD = 4;
    private static Color inactBgColor;
    private static Color actBgColor;
    private static Color borderHighlight;
    private static Color borderShadow;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private MetalViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 21 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 4;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintBottomBorder(graphics, jComponent);
    }

    private void paintBottomBorder(Graphics graphics, JComponent jComponent) {
        Color color = this.isActive() ? MetalViewTabDisplayerUI.getActBgColor() : MetalViewTabDisplayerUI.getInactBgColor();
        graphics.setColor(color);
        Rectangle rectangle = jComponent.getBounds();
        graphics.fillRect(1, rectangle.height - 3, rectangle.width - 1, 2);
        graphics.setColor(this.getBorderShadow());
        graphics.drawLine(1, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            int n7;
            Component component = this.getControlButtons();
            int n8 = 0;
            if (null != component) {
                Dimension dimension = component.getPreferredSize();
                n8 = dimension.width + 5 + 2;
                n6 = n4 - (n8 + 10);
                component.setLocation(n2 + n6 + 10 + 5, n3 + (n5 - dimension.height) / 2 + 1);
            }
            if ((n7 = n4 - (5 + (n6 = (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 5), (int)(n5 - fontMetrics.getDescent() - 4), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true)) + 5 + n8)) > 0) {
                this.paintBump(n, graphics, n2 + 5 + n6 + 5, n3 + 4, n7, n5 - 8);
            }
        } else {
            n6 = n4 - 10;
            HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 5), (int)(n5 - fontMetrics.getDescent() - 4), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = this.getBorderHighlight();
        Color color2 = this.getBorderShadow();
        boolean bl = this.isSelected(n);
        boolean bl2 = n == 0;
        boolean bl3 = n == this.getDataModel().size() - 1;
        graphics.translate(n2, n3);
        graphics.setColor(color2);
        if (!bl2) {
            graphics.drawLine(0, 0, 0, n5 - 5);
        }
        if (!bl) {
            graphics.drawLine(1, n5 - 5, bl3 ? n4 - 1 : n4, n5 - 5);
        }
        graphics.setColor(color);
        graphics.drawLine(1, 0, n4 - 1, 0);
        if (bl2) {
            graphics.drawLine(0, 0, 0, n5 - 2);
        }
        if (!bl) {
            graphics.drawLine(0, n5 - 4, bl3 ? n4 - 1 : n4, n5 - 4);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        if (bl2 && !bl3) {
            graphics.setColor(MetalViewTabDisplayerUI.getActBgColor());
            graphics.fillRect(n2, n3, n4, n5 - 3);
        } else if (bl3) {
            graphics.setColor(MetalEditorTabCellRenderer.ATTENTION_COLOR);
            graphics.fillRect(n2, n3, n4, n5 - 3);
        } else {
            graphics.setColor(MetalViewTabDisplayerUI.getInactBgColor());
            graphics.fillRect(n2, n3, n4, n5 - 3);
        }
    }

    private void paintBump(int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        ColorUtil.paintViewTabBump(graphics, n2, n3, n4, n5, this.isFocused(n) ? 4 : 2);
    }

    static Color getInactBgColor() {
        if (inactBgColor == null && (inactBgColor = (Color)UIManager.get("inactiveCaption")) == null) {
            inactBgColor = new Color(204, 204, 204);
        }
        return inactBgColor;
    }

    static Color getActBgColor() {
        if (actBgColor == null && (actBgColor = (Color)UIManager.get("activeCaption")) == null) {
            actBgColor = new Color(204, 204, 255);
        }
        return actBgColor;
    }

    private Color getBorderHighlight() {
        if (borderHighlight == null) {
            borderHighlight = MetalViewTabDisplayerUI.getInactBgColor().brighter();
        }
        return borderHighlight;
    }

    private Color getBorderShadow() {
        if (borderShadow == null) {
            borderShadow = MetalViewTabDisplayerUI.getInactBgColor().darker();
        }
        return borderShadow;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_bigclose_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_bigclose_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/metal_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/metal_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/metal_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        MetalViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

