/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"ltrimstr/1"})
public class LTrimStrFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("ltrimstr", in, JsonNodeType.STRING);
        String text = in.asText();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode prefixNode : args.get(0).apply(scope, in)) {
            if (!prefixNode.isTextual()) {
                throw new JsonQueryException("1st argument to ltrimstr() must be string, got " + prefixNode.getNodeType());
            }
            String prefix = prefixNode.asText();
            if (!text.startsWith(prefix)) {
                out.add(in);
                continue;
            }
            out.add((JsonNode)new TextNode(text.substring(prefix.length(), text.length())));
        }
        return out;
    }
}

