/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.util.SolrPluginUtils;

public class CloudMLTQParser
extends QParser {
    private static final Pattern splitList = Pattern.compile(",| ");

    public CloudMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String[] fieldNames;
        String[] fields;
        String id = this.localParams.get("v");
        SolrDocument doc = this.getDocument(id);
        if (doc == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + id + "]");
        }
        String[] qf = this.localParams.getParams("qf");
        Map<Object, Object> boostFields = new HashMap();
        MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
        mlt.setMinTermFreq(this.localParams.getInt("mintf", 2));
        mlt.setMinDocFreq(this.localParams.getInt("mindf", 0));
        mlt.setMinWordLen(this.localParams.getInt("minwl", 0));
        mlt.setMaxWordLen(this.localParams.getInt("maxwl", 0));
        mlt.setMaxQueryTerms(this.localParams.getInt("maxqt", 25));
        mlt.setMaxNumTokensParsed(this.localParams.getInt("maxntp", 5000));
        mlt.setMaxDocFreq(this.localParams.getInt("maxdf", Integer.MAX_VALUE));
        Boolean boost = this.localParams.getBool("boost", false);
        mlt.setBoost(boost.booleanValue());
        mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
        HashMap filteredDocument = new HashMap();
        if (qf != null) {
            fields = new ArrayList();
            for (String fieldName : qf) {
                if (StringUtils.isEmpty((String)fieldName)) continue;
                String[] strings = splitList.split(fieldName);
                for (String string : strings) {
                    if (StringUtils.isEmpty((String)string)) continue;
                    fields.add(string);
                }
            }
            boostFields = SolrPluginUtils.parseFieldBoosts(fields.toArray(new String[0]));
            fieldNames = boostFields.keySet().toArray(new String[0]);
        } else {
            fields = new ArrayList();
            for (String field : doc.getFieldNames()) {
                SchemaField f = this.req.getSchema().getFieldOrNull(field);
                if (f == null || !f.stored() || !f.getType().isExplicitAnalyzer()) continue;
                fields.add(field);
            }
            fieldNames = fields.toArray(new String[0]);
        }
        if (fieldNames.length < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: qf");
        }
        mlt.setFieldNames(fieldNames);
        for (String field : fieldNames) {
            Collection fieldValues = doc.getFieldValues(field);
            if (fieldValues == null) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (Object val : fieldValues) {
                if (val instanceof IndexableField) {
                    values.add(((IndexableField)val).stringValue());
                    continue;
                }
                values.add((String)val);
            }
            filteredDocument.put(field, values);
        }
        try {
            Query rawMLTQuery = mlt.like(filteredDocument);
            BooleanQuery boostedMLTQuery = (BooleanQuery)rawMLTQuery;
            if (boost.booleanValue() && boostFields.size() > 0) {
                BooleanQuery.Builder newQ = new BooleanQuery.Builder();
                newQ.setMinimumNumberShouldMatch(boostedMLTQuery.getMinimumNumberShouldMatch());
                for (BooleanClause clause : boostedMLTQuery) {
                    Float fieldBoost;
                    Query q = clause.getQuery();
                    float originalBoost = 1.0f;
                    if (q instanceof BoostQuery) {
                        BoostQuery bq = (BoostQuery)q;
                        q = bq.getQuery();
                        originalBoost = bq.getBoost();
                    }
                    q = (fieldBoost = (Float)boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                    newQ.add(q, clause.getOccur());
                }
                boostedMLTQuery = QueryUtils.build(newQ, this);
            }
            BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
            realMLTQuery.add((Query)boostedMLTQuery, BooleanClause.Occur.MUST);
            realMLTQuery.add(this.createIdQuery(this.req.getSchema().getUniqueKeyField().getName(), id), BooleanClause.Occur.MUST_NOT);
            return realMLTQuery.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad Request");
        }
    }

    private SolrDocument getDocument(String id) {
        SolrCore core = this.req.getCore();
        SolrQueryResponse rsp = new SolrQueryResponse();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("id", new String[]{id});
        SolrQueryRequestBase request = new SolrQueryRequestBase(core, (SolrParams)params){};
        core.getRequestHandler("/get").handleRequest(request, rsp);
        NamedList response = rsp.getValues();
        return (SolrDocument)response.get("doc");
    }

    private Query createIdQuery(String defaultField, String uniqueValue) {
        return new TermQuery(this.req.getSchema().getField(defaultField).getType().getNumberType() != null ? this.createNumericTerm(defaultField, uniqueValue) : new Term(defaultField, uniqueValue));
    }

    private Term createNumericTerm(String field, String uniqueValue) {
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(6);
        LegacyNumericUtils.intToPrefixCoded(Integer.parseInt(uniqueValue), 0, bytesRefBuilder);
        return new Term(field, bytesRefBuilder.toBytesRef());
    }
}

