/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.JsonSchemaCreator;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedApi
extends Api
implements PermissionNameProvider,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ERR = "Error executing commands :";
    private EndPoint endPoint;
    private final Map<String, Cmd> commands;
    private final Cmd singletonCommand;
    private final Api fallback;

    @Override
    public void close() throws IOException {
        block1: {
            Iterator<Cmd> iterator = this.commands.values().iterator();
            if (!iterator.hasNext()) break block1;
            Cmd value = iterator.next();
            if (value.obj instanceof Closeable) {
                ((Closeable)value.obj).close();
            }
        }
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public static List<Api> getApis(Object obj) {
        return AnnotatedApi.getApis(obj.getClass(), obj);
    }

    public static List<Api> getApis(Class<? extends Object> klas, Object obj) {
        if (!Modifier.isPublic(klas.getModifiers())) {
            throw new RuntimeException(klas.getName() + " is not public");
        }
        if (klas.getAnnotation(EndPoint.class) != null) {
            EndPoint endPoint = klas.getAnnotation(EndPoint.class);
            ArrayList<Method> methods = new ArrayList<Method>();
            HashMap<String, Cmd> commands = new HashMap<String, Cmd>();
            for (Method m : klas.getMethods()) {
                Command command = m.getAnnotation(Command.class);
                if (command == null) continue;
                methods.add(m);
                if (commands.containsKey(command.name())) {
                    throw new RuntimeException("Duplicate commands " + command.name());
                }
                commands.put(command.name(), new Cmd(command.name(), obj, m));
            }
            if (commands.isEmpty()) {
                throw new RuntimeException("No method with @Command in class: " + klas.getName());
            }
            SpecProvider specProvider = AnnotatedApi.readSpec(endPoint, methods);
            return Collections.singletonList(new AnnotatedApi(specProvider, endPoint, commands, null));
        }
        ArrayList<Api> apis = new ArrayList<Api>();
        for (Method m : klas.getMethods()) {
            EndPoint endPoint = m.getAnnotation(EndPoint.class);
            if (endPoint == null) continue;
            Cmd cmd = new Cmd("", obj, m);
            SpecProvider specProvider = AnnotatedApi.readSpec(endPoint, Collections.singletonList(m));
            apis.add(new AnnotatedApi(specProvider, endPoint, Collections.singletonMap("", cmd), null));
        }
        if (apis.isEmpty()) {
            throw new RuntimeException("Invalid Class : " + klas.getName() + " No @EndPoints");
        }
        return apis;
    }

    private AnnotatedApi(SpecProvider specProvider, EndPoint endPoint, Map<String, Cmd> commands, Api fallback) {
        super(specProvider);
        this.endPoint = endPoint;
        this.fallback = fallback;
        this.commands = commands;
        this.singletonCommand = commands.get("");
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return this.endPoint.permission();
    }

    private static SpecProvider readSpec(EndPoint endPoint, List<Method> m) {
        return () -> {
            LinkedHashMap<String, Cloneable> map = new LinkedHashMap<String, Cloneable>();
            ArrayList<String> methods = new ArrayList<String>();
            for (SolrRequest.METHOD method : endPoint.method()) {
                methods.add(method.name());
            }
            map.put("methods", methods);
            map.put("url", (Cloneable)new ValidatingJsonMap(Collections.singletonMap("paths", Arrays.asList(endPoint.path()))));
            HashMap<String, Map<String, Object>> cmds = new HashMap<String, Map<String, Object>>();
            for (Method method : m) {
                Command command = method.getAnnotation(Command.class);
                if (command == null || command.name().isEmpty()) continue;
                cmds.put(command.name(), AnnotatedApi.createSchema(method));
            }
            if (!cmds.isEmpty()) {
                map.put("commands", cmds);
            }
            return new ValidatingJsonMap(map);
        };
    }

    @Override
    public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.singletonCommand != null) {
            this.singletonCommand.invoke(req, rsp, null);
            return;
        }
        List<CommandOperation> cmds = req.getCommands(true);
        boolean allExists = true;
        for (CommandOperation cmd : cmds) {
            if (this.commands.containsKey(cmd.name)) continue;
            cmd.addError("No such command supported: " + cmd.name);
            allExists = false;
        }
        if (!allExists) {
            if (this.fallback != null) {
                this.fallback.call(req, rsp);
                return;
            }
            throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error processing commands", CommandOperation.captureErrors(cmds));
        }
        for (CommandOperation cmd : cmds) {
            this.commands.get(cmd.name).invoke(req, rsp, cmd);
        }
        List errs = CommandOperation.captureErrors(cmds);
        if (!errs.isEmpty()) {
            log.error("{}{}", (Object)ERR, (Object)Utils.toJSONString((Object)errs));
            throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, ERR, errs);
        }
    }

    public static Map<String, Object> createSchema(Method m) {
        Type[] types = m.getGenericParameterTypes();
        Type t = null;
        if (types.length == 3) {
            t = types[2];
        }
        if (types.length == 1) {
            t = types[0];
        }
        if (t != null) {
            ParameterizedType typ;
            if (t instanceof ParameterizedType && (typ = (ParameterizedType)t).getRawType() == PayloadObj.class) {
                t = typ.getActualTypeArguments()[0];
            }
            return JsonSchemaCreator.getSchema((Type)t);
        }
        return null;
    }

    static class Cmd {
        final String command;
        final MethodHandle method;
        final Object obj;
        ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper();
        int paramsCount;
        Class parameterClass;
        boolean isWrappedInPayloadObj = false;

        Cmd(String command, Object obj, Method method) {
            this.command = command;
            this.obj = obj;
            try {
                this.method = MethodHandles.publicLookup().unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access method, may be not public or accessible ", e);
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            this.paramsCount = parameterTypes.length;
            if (parameterTypes.length == 1) {
                this.readPayloadType(method.getGenericParameterTypes()[0]);
            } else if (parameterTypes.length == 3) {
                if (parameterTypes[0] != SolrQueryRequest.class || parameterTypes[1] != SolrQueryResponse.class) {
                    throw new RuntimeException("Invalid params for method " + method);
                }
                Type t = method.getGenericParameterTypes()[2];
                this.readPayloadType(t);
            }
            if (parameterTypes.length > 3) {
                throw new RuntimeException("Invalid params count for method " + method);
            }
        }

        private void readPayloadType(Type t) {
            if (t instanceof ParameterizedType) {
                ParameterizedType typ = (ParameterizedType)t;
                if (typ.getRawType() == PayloadObj.class) {
                    this.isWrappedInPayloadObj = true;
                    if (typ.getActualTypeArguments().length == 0) {
                        this.parameterClass = Map.class;
                        return;
                    }
                    Type t1 = typ.getActualTypeArguments()[0];
                    if (t1 instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)t1;
                        this.parameterClass = (Class)parameterizedType.getRawType();
                    } else {
                        this.parameterClass = (Class)typ.getActualTypeArguments()[0];
                    }
                }
            } else {
                this.parameterClass = (Class)t;
            }
        }

        void invoke(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation cmd) {
            Object original = null;
            try {
                Object o = null;
                String commandName = null;
                if (this.paramsCount == 1) {
                    PayloadObj<Object> payloadObj;
                    if (cmd == null) {
                        if (this.parameterClass != null) {
                            try {
                                ContentStream stream = req.getContentStreams().iterator().next();
                                o = this.mapper.readValue(stream.getStream(), this.parameterClass);
                            }
                            catch (IOException e) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid payload", (Throwable)e);
                            }
                        }
                    } else {
                        commandName = cmd.name;
                        original = cmd.getCommandData();
                        o = original;
                        if (o instanceof Map && this.parameterClass != null && this.parameterClass != Map.class) {
                            o = this.mapper.readValue(Utils.toJSONString((Object)o), this.parameterClass);
                        }
                    }
                    cmd = payloadObj = new PayloadObj<Object>(commandName, original, o, req, rsp);
                    this.method.invoke(this.obj, payloadObj);
                    this.checkForErrorInPayload(cmd);
                } else if (this.paramsCount == 2) {
                    this.method.invoke(this.obj, req, rsp);
                } else {
                    o = cmd.getCommandData();
                    if (o instanceof Map && this.parameterClass != null) {
                        o = this.mapper.readValue(Utils.toJSONString((Object)o), this.parameterClass);
                    }
                    if (this.isWrappedInPayloadObj) {
                        PayloadObj<Object> payloadObj = new PayloadObj<Object>(cmd.name, cmd.getCommandData(), o, req, rsp);
                        cmd = payloadObj;
                        this.method.invoke(this.obj, req, rsp, payloadObj);
                    } else {
                        this.method.invoke(this.obj, req, rsp, o);
                    }
                    this.checkForErrorInPayload(cmd);
                }
            }
            catch (RuntimeException se) {
                log.error("Error executing command  ", (Throwable)se);
                throw se;
            }
            catch (Throwable e) {
                log.error("Error executing command : ", e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
            }
        }

        private void checkForErrorInPayload(CommandOperation cmd) {
            if (cmd.hasError()) {
                throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error executing command", CommandOperation.captureErrors(Collections.singletonList(cmd)));
            }
        }
    }
}

