/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Normalizer2;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class ICUNormalizer2Filter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final Normalizer2 normalizer;
    private final StringBuilder buffer = new StringBuilder();

    public ICUNormalizer2Filter(TokenStream input) {
        this(input, Normalizer2.getInstance(null, (String)"nfkc_cf", (Normalizer2.Mode)Normalizer2.Mode.COMPOSE));
    }

    public ICUNormalizer2Filter(TokenStream input, Normalizer2 normalizer) {
        super(input);
        this.normalizer = normalizer;
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.normalizer.quickCheck((CharSequence)this.termAtt) != Normalizer.YES) {
                this.buffer.setLength(0);
                this.normalizer.normalize((CharSequence)this.termAtt, this.buffer);
                this.termAtt.setEmpty().append(this.buffer);
            }
            return true;
        }
        return false;
    }
}

