/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.asserting.AssertingCodec;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.TestUtil;

public class AssertingDocValuesFormat
extends DocValuesFormat {
    private final DocValuesFormat in = TestUtil.getDefaultDocValuesFormat();

    public AssertingDocValuesFormat() {
        super("Asserting");
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        DocValuesConsumer consumer = this.in.fieldsConsumer(state);
        assert (consumer != null);
        return new AssertingDocValuesConsumer(consumer, state.segmentInfo.maxDoc());
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        assert (state.fieldInfos.hasDocValues());
        DocValuesProducer producer = this.in.fieldsProducer(state);
        assert (producer != null);
        return new AssertingDocValuesProducer(producer, state.segmentInfo.maxDoc(), false);
    }

    static class AssertingDocValuesProducer
    extends DocValuesProducer {
        private final DocValuesProducer in;
        private final int maxDoc;
        private final boolean merging;
        private final Thread creationThread;

        AssertingDocValuesProducer(DocValuesProducer in, int maxDoc, boolean merging) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.merging = merging;
            this.creationThread = Thread.currentThread();
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            if (this.merging) {
                AssertingCodec.assertThread("DocValuesProducer", this.creationThread);
            }
            assert (field.getDocValuesType() == DocValuesType.NUMERIC);
            NumericDocValues values = this.in.getNumeric(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingNumericDocValues(values, this.maxDoc);
        }

        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            if (this.merging) {
                AssertingCodec.assertThread("DocValuesProducer", this.creationThread);
            }
            assert (field.getDocValuesType() == DocValuesType.BINARY);
            BinaryDocValues values = this.in.getBinary(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingBinaryDocValues(values, this.maxDoc);
        }

        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            if (this.merging) {
                AssertingCodec.assertThread("DocValuesProducer", this.creationThread);
            }
            assert (field.getDocValuesType() == DocValuesType.SORTED);
            SortedDocValues values = this.in.getSorted(field);
            assert (values != null);
            return new AssertingLeafReader.AssertingSortedDocValues(values, this.maxDoc);
        }

        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            if (this.merging) {
                AssertingCodec.assertThread("DocValuesProducer", this.creationThread);
            }
            assert (field.getDocValuesType() == DocValuesType.SORTED_NUMERIC);
            SortedNumericDocValues values = this.in.getSortedNumeric(field);
            assert (values != null);
            return AssertingLeafReader.AssertingSortedNumericDocValues.create(values, this.maxDoc);
        }

        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            if (this.merging) {
                AssertingCodec.assertThread("DocValuesProducer", this.creationThread);
            }
            assert (field.getDocValuesType() == DocValuesType.SORTED_SET);
            SortedSetDocValues values = this.in.getSortedSet(field);
            assert (values != null);
            return AssertingLeafReader.AssertingSortedSetDocValues.create(values, this.maxDoc);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public DocValuesProducer getMergeInstance() {
            return new AssertingDocValuesProducer(this.in.getMergeInstance(), this.maxDoc, true);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }

    static class AssertingDocValuesConsumer
    extends DocValuesConsumer {
        private final DocValuesConsumer in;
        private final int maxDoc;

        AssertingDocValuesConsumer(DocValuesConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            int docID;
            NumericDocValues values = valuesProducer.getNumeric(field);
            int lastDocID = -1;
            while ((docID = values.nextDoc()) != Integer.MAX_VALUE) {
                assert (docID >= 0 && docID < this.maxDoc);
                assert (docID > lastDocID);
                lastDocID = docID;
                long l = values.longValue();
            }
            this.in.addNumericField(field, valuesProducer);
        }

        public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            int docID;
            BinaryDocValues values = valuesProducer.getBinary(field);
            int lastDocID = -1;
            while ((docID = values.nextDoc()) != Integer.MAX_VALUE) {
                assert (docID >= 0 && docID < this.maxDoc);
                assert (docID > lastDocID);
                lastDocID = docID;
                BytesRef value = values.binaryValue();
                assert (value.isValid());
            }
            this.in.addBinaryField(field, valuesProducer);
        }

        public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            int docID;
            SortedDocValues values = valuesProducer.getSorted(field);
            int valueCount = values.getValueCount();
            assert (valueCount <= this.maxDoc);
            BytesRef lastValue = null;
            for (int ord = 0; ord < valueCount; ++ord) {
                BytesRef b = values.lookupOrd(ord);
                assert (b != null);
                assert (b.isValid());
                if (ord > 0) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
            }
            FixedBitSet seenOrds = new FixedBitSet(valueCount);
            int lastDocID = -1;
            while ((docID = values.nextDoc()) != Integer.MAX_VALUE) {
                assert (docID >= 0 && docID < this.maxDoc);
                assert (docID > lastDocID);
                lastDocID = docID;
                int ord = values.ordValue();
                assert (ord >= 0 && ord < valueCount);
                seenOrds.set(ord);
            }
            assert (seenOrds.cardinality() == valueCount);
            this.in.addSortedField(field, valuesProducer);
        }

        public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            int docID;
            SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
            long valueCount = 0L;
            int lastDocID = -1;
            while ((docID = values.nextDoc()) != Integer.MAX_VALUE) {
                assert (values.docID() > lastDocID);
                lastDocID = values.docID();
                int count = values.docValueCount();
                assert (count > 0);
                valueCount += (long)count;
                long previous = Long.MIN_VALUE;
                for (int i = 0; i < count; ++i) {
                    long nextValue = values.nextValue();
                    assert (nextValue >= previous);
                    previous = nextValue;
                }
            }
            this.in.addSortedNumericField(field, valuesProducer);
        }

        public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            int docID;
            SortedSetDocValues values = valuesProducer.getSortedSet(field);
            long valueCount = values.getValueCount();
            BytesRef lastValue = null;
            for (long i = 0L; i < valueCount; ++i) {
                BytesRef b = values.lookupOrd(i);
                assert (b != null);
                assert (b.isValid());
                if (i > 0L) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
            }
            int docCount = 0;
            LongBitSet seenOrds = new LongBitSet(valueCount);
            while ((docID = values.nextDoc()) != Integer.MAX_VALUE) {
                long ord;
                ++docCount;
                long lastOrd = -1L;
                while ((ord = values.nextOrd()) != -1L) {
                    assert (ord >= 0L && ord < valueCount) : "ord=" + ord + " is not in bounds 0 .." + (valueCount - 1L);
                    assert (ord > lastOrd) : "ord=" + ord + ",lastOrd=" + lastOrd;
                    seenOrds.set(ord);
                    lastOrd = ord;
                }
            }
            assert (seenOrds.cardinality() == valueCount);
            this.in.addSortedSetField(field, valuesProducer);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }
}

