/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.statistic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.calcite.plan.RelOptTable;

public enum MapSqlStatisticProvider implements SqlStatisticProvider
{
    INSTANCE;

    private final ImmutableMap<String, Double> cardinalityMap;
    private final ImmutableMultimap<String, ImmutableList<String>> keyMap;

    private MapSqlStatisticProvider() {
        Initializer initializer = new Initializer().put("foodmart", "agg_c_14_sales_fact_1997", 86805, "id").put("foodmart", "account", 11, "account_id").put("foodmart", "category", 4, "category_id").put("foodmart", "currency", 10281, "currency_id").put("foodmart", "customer", 10281, "customer_id").put("foodmart", "days", 7, "day").put("foodmart", "employee", 1155, "employee_id").put("foodmart", "employee_closure", 7179, new Object[0]).put("foodmart", "department", 10281, "department_id").put("foodmart", "inventory_fact_1997", 4070, new Object[0]).put("foodmart", "position", 18, "position_id").put("foodmart", "product", 1560, "product_id").put("foodmart", "product_class", 110, "product_class_id").put("foodmart", "promotion", 1864, "promotion_id").put("foodmart", "region", 24, "region_id").put("foodmart", "salary", 21252, new Object[0]).put("foodmart", "sales_fact_1997", 86837, new Object[0]).put("foodmart", "store", 25, "store_id").put("foodmart", "store_ragged", 25, "store_id").put("foodmart", "time_by_day", 730, "time_id", "the_date").put("foodmart", "warehouse", 24, "warehouse_id").put("foodmart", "warehouse_class", 6, "warehouse_class_id").put("scott", "EMP", 10, "EMPNO").put("scott", "DEPT", 4, "DEPTNO").put("tpcds", "CALL_CENTER", 8, "id").put("tpcds", "CATALOG_PAGE", 11718, "id").put("tpcds", "CATALOG_RETURNS", 144067, "id").put("tpcds", "CATALOG_SALES", 1441548, "id").put("tpcds", "CUSTOMER", 100000, "id").put("tpcds", "CUSTOMER_ADDRESS", 50000, "id").put("tpcds", "CUSTOMER_DEMOGRAPHICS", 1920800, "id").put("tpcds", "DATE_DIM", 73049, "id").put("tpcds", "DBGEN_VERSION", 1, "id").put("tpcds", "HOUSEHOLD_DEMOGRAPHICS", 7200, "id").put("tpcds", "INCOME_BAND", 20, "id").put("tpcds", "INVENTORY", 11745000, "id").put("tpcds", "ITEM", 18000, "id").put("tpcds", "PROMOTION", 300, "id").put("tpcds", "REASON", 35, "id").put("tpcds", "SHIP_MODE", 20, "id").put("tpcds", "STORE", 12, "id").put("tpcds", "STORE_RETURNS", 287514, "id").put("tpcds", "STORE_SALES", 2880404, "id").put("tpcds", "TIME_DIM", 86400, "id").put("tpcds", "WAREHOUSE", 5, "id").put("tpcds", "WEB_PAGE", 60, "id").put("tpcds", "WEB_RETURNS", 71763, "id").put("tpcds", "WEB_SALES", 719384, "id").put("tpcds", "WEB_SITE", 1, "id");
        this.cardinalityMap = initializer.cardinalityMapBuilder.build();
        this.keyMap = initializer.keyMapBuilder.build();
    }

    @Override
    public double tableCardinality(RelOptTable table) {
        List qualifiedName = table.maybeUnwrap(JdbcTable.class).map(value -> Arrays.asList(value.jdbcSchemaName, value.jdbcTableName)).orElseGet(table::getQualifiedName);
        return (Double)this.cardinalityMap.get((Object)qualifiedName.toString());
    }

    @Override
    public boolean isForeignKey(RelOptTable fromTable, List<Integer> fromColumns, RelOptTable toTable, List<Integer> toColumns) {
        return this.isKey(toTable, toColumns) && !"[foodmart, employee].[supervisor_id]".equals(fromTable.getQualifiedName() + "." + MapSqlStatisticProvider.columnNames(fromTable, fromColumns));
    }

    @Override
    public boolean isKey(RelOptTable table, List<Integer> columns) {
        return columns.stream().allMatch(columnOrdinal -> columnOrdinal >= 0 && columnOrdinal < table.getRowType().getFieldCount()) && this.keyMap.get((Object)table.getQualifiedName().toString()).contains(MapSqlStatisticProvider.columnNames(table, columns));
    }

    private static List<String> columnNames(RelOptTable table, List<Integer> columns) {
        return columns.stream().map(columnOrdinal -> table.getRowType().getFieldNames().get((int)columnOrdinal)).collect(Collectors.toList());
    }

    private static class Initializer {
        final ImmutableMap.Builder<String, Double> cardinalityMapBuilder = ImmutableMap.builder();
        final ImmutableMultimap.Builder<String, ImmutableList<String>> keyMapBuilder = ImmutableMultimap.builder();

        private Initializer() {
        }

        Initializer put(String schema, String table, int count, Object ... keys) {
            String qualifiedName = Arrays.asList(schema, table).toString();
            this.cardinalityMapBuilder.put((Object)qualifiedName, (Object)count);
            for (Object key : keys) {
                ImmutableList keyList;
                if (key instanceof String) {
                    keyList = ImmutableList.of((Object)((String)key));
                } else if (key instanceof String[]) {
                    keyList = ImmutableList.copyOf((Object[])((String[])key));
                } else {
                    throw new AssertionError((Object)("unknown key " + key));
                }
                this.keyMapBuilder.put((Object)qualifiedName, (Object)keyList);
            }
            return this;
        }
    }
}

