/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlMultisetQueryConstructor
extends SqlSpecialOperator {
    public SqlMultisetQueryConstructor() {
        this("MULTISET", SqlKind.MULTISET_QUERY_CONSTRUCTOR);
    }

    protected SqlMultisetQueryConstructor(String name, SqlKind kind) {
        super(name, kind, 200, false, ReturnTypes.ARG0, null, OperandTypes.VARIADIC);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type = SqlMultisetQueryConstructor.getComponentType(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        Objects.requireNonNull(type, "inferred multiset query element type");
        return SqlTypeUtil.createMultisetType(opBinding.getTypeFactory(), type, false);
    }

    private static @Nullable RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return typeFactory.leastRestrictive(argTypes);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveType(callBinding, callBinding.operands());
        RelDataType componentType = SqlMultisetQueryConstructor.getComponentType(callBinding.getTypeFactory(), argTypes);
        if (null == componentType) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        subSelect.validateExpr(validator, scope);
        SqlValidatorNamespace ns = validator.getNamespace(subSelect);
        assert (ns != null) : "namespace is missing for " + subSelect;
        assert (null != ns.getRowType());
        return SqlTypeUtil.createMultisetType(validator.getTypeFactory(), ns.getRowType(), false);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(this.getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

