/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.UnmodifiableArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBasicCall
extends SqlCall {
    private SqlOperator operator;
    public final @Nullable SqlNode[] operands;
    private final @Nullable SqlLiteral functionQuantifier;
    private final boolean expanded;

    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos) {
        this(operator, operands, pos, false, null);
    }

    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos, boolean expanded, @Nullable SqlLiteral functionQualifier) {
        super(pos);
        this.operator = Objects.requireNonNull(operator, "operator");
        this.operands = operands;
        this.expanded = expanded;
        this.functionQuantifier = functionQualifier;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        this.operands[i] = operand;
    }

    public void setOperator(SqlOperator operator) {
        this.operator = Objects.requireNonNull(operator, "operator");
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    public @Nullable SqlNode[] getOperands() {
        return this.operands;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return UnmodifiableArrayList.of(this.operands);
    }

    @Override
    public <S extends SqlNode> S operand(int i) {
        return (S)((SqlNode)Nullness.castNonNull((Object)this.operands[i]));
    }

    @Override
    public int operandCount() {
        return this.operands.length;
    }

    @Override
    public @Nullable SqlLiteral getFunctionQuantifier() {
        return this.functionQuantifier;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getOperator().createCall(this.getFunctionQuantifier(), pos, this.operands);
    }
}

