/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.stream;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.stream.Delta;
import org.apache.calcite.rel.stream.LogicalDelta;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;

public class StreamRules {
    public static final ImmutableList<RelOptRule> RULES = ImmutableList.of((Object)DeltaProjectTransposeRule.Config.DEFAULT.toRule(), (Object)DeltaFilterTransposeRule.Config.DEFAULT.toRule(), (Object)DeltaAggregateTransposeRule.Config.DEFAULT.toRule(), (Object)DeltaSortTransposeRule.Config.DEFAULT.toRule(), (Object)DeltaUnionTransposeRule.Config.DEFAULT.toRule(), (Object)DeltaJoinTransposeRule.Config.DEFAULT.toRule(), (Object)DeltaTableScanRule.Config.DEFAULT.toRule(), (Object)DeltaTableScanToEmptyRule.Config.DEFAULT.toRule());

    private StreamRules() {
    }

    public static class DeltaJoinTransposeRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaJoinTransposeRule(Config config) {
            super(config);
        }

        @Deprecated
        public DeltaJoinTransposeRule() {
            this((Config)Config.DEFAULT.toRule().config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Join join = (Join)call.rel(1);
            RelNode left = join.getLeft();
            RelNode right = join.getRight();
            LogicalDelta rightWithDelta = LogicalDelta.create(right);
            LogicalJoin joinL = LogicalJoin.create(left, rightWithDelta, join.getHints(), join.getCondition(), join.getVariablesSet(), join.getJoinType(), join.isSemiJoinDone(), (ImmutableList<RelDataTypeField>)ImmutableList.copyOf(join.getSystemFieldList()));
            LogicalDelta leftWithDelta = LogicalDelta.create(left);
            LogicalJoin joinR = LogicalJoin.create(leftWithDelta, right, join.getHints(), join.getCondition(), join.getVariablesSet(), join.getJoinType(), join.isSemiJoinDone(), (ImmutableList<RelDataTypeField>)ImmutableList.copyOf(join.getSystemFieldList()));
            ArrayList<RelNode> inputsToUnion = new ArrayList<RelNode>();
            inputsToUnion.add(joinL);
            inputsToUnion.add(joinR);
            LogicalUnion newNode = LogicalUnion.create(inputsToUnion, true);
            call.transformTo(newNode);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(Join.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaJoinTransposeRule toRule() {
                return new DeltaJoinTransposeRule(this);
            }
        }
    }

    public static class DeltaTableScanToEmptyRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaTableScanToEmptyRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            RelOptTable relOptTable = scan.getTable();
            StreamableTable streamableTable = relOptTable.unwrap(StreamableTable.class);
            RelBuilder builder = call.builder();
            if (streamableTable == null) {
                call.transformTo(builder.values(delta.getRowType()).build());
            }
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(TableScan.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaTableScanToEmptyRule toRule() {
                return new DeltaTableScanToEmptyRule(this);
            }
        }
    }

    public static class DeltaTableScanRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaTableScanRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            RelOptCluster cluster = delta.getCluster();
            RelOptTable relOptTable = scan.getTable();
            StreamableTable streamableTable = relOptTable.unwrap(StreamableTable.class);
            if (streamableTable != null) {
                Table table1 = streamableTable.stream();
                RelOptTableImpl relOptTable2 = RelOptTableImpl.create(relOptTable.getRelOptSchema(), relOptTable.getRowType(), table1, (ImmutableList<String>)ImmutableList.builder().addAll(relOptTable.getQualifiedName()).add((Object)"(STREAM)").build());
                LogicalTableScan newScan = LogicalTableScan.create(cluster, relOptTable2, scan.getHints());
                call.transformTo(newScan);
            }
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(TableScan.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaTableScanRule toRule() {
                return new DeltaTableScanRule(this);
            }
        }
    }

    public static class DeltaUnionTransposeRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaUnionTransposeRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Union union = (Union)call.rel(1);
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : union.getInputs()) {
                LogicalDelta newDelta = LogicalDelta.create(input);
                newInputs.add(newDelta);
            }
            LogicalUnion newUnion = LogicalUnion.create(newInputs, union.all);
            call.transformTo(newUnion);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(Union.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaUnionTransposeRule toRule() {
                return new DeltaUnionTransposeRule(this);
            }
        }
    }

    public static class DeltaSortTransposeRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaSortTransposeRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Sort sort = (Sort)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(sort.getInput());
            LogicalSort newSort = LogicalSort.create(newDelta, sort.collation, sort.offset, sort.fetch);
            call.transformTo(newSort);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(Sort.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaSortTransposeRule toRule() {
                return new DeltaSortTransposeRule(this);
            }
        }
    }

    public static class DeltaAggregateTransposeRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaAggregateTransposeRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Aggregate aggregate = (Aggregate)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(aggregate.getInput());
            LogicalAggregate newAggregate = LogicalAggregate.create((RelNode)newDelta, aggregate.getHints(), aggregate.getGroupSet(), aggregate.groupSets, aggregate.getAggCallList());
            call.transformTo(newAggregate);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(Aggregate.class).predicate(Aggregate::isSimple).anyInputs())).as(Config.class);

            @Override
            default public DeltaAggregateTransposeRule toRule() {
                return new DeltaAggregateTransposeRule(this);
            }

            default public Config withOperandFor(Class<? extends RelNode> relClass) {
                return this.withOperandSupplier(b -> b.operand(relClass).anyInputs()).as(Config.class);
            }
        }
    }

    public static class DeltaFilterTransposeRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaFilterTransposeRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Filter filter = (Filter)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(filter.getInput());
            LogicalFilter newFilter = LogicalFilter.create(newDelta, filter.getCondition());
            call.transformTo(newFilter);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(Filter.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaFilterTransposeRule toRule() {
                return new DeltaFilterTransposeRule(this);
            }

            default public Config withOperandFor(Class<? extends RelNode> relClass) {
                return this.withOperandSupplier(b -> b.operand(relClass).anyInputs()).as(Config.class);
            }
        }
    }

    public static class DeltaProjectTransposeRule
    extends RelRule<Config>
    implements TransformationRule {
        protected DeltaProjectTransposeRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Project project = (Project)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(project.getInput());
            LogicalProject newProject = LogicalProject.create((RelNode)newDelta, project.getHints(), project.getProjects(), project.getRowType().getFieldNames());
            call.transformTo(newProject);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Delta.class).oneInput(b1 -> b1.operand(Project.class).anyInputs())).as(Config.class);

            @Override
            default public DeltaProjectTransposeRule toRule() {
                return new DeltaProjectTransposeRule(this);
            }

            default public Config withOperandFor(Class<? extends RelNode> relClass) {
                return this.withOperandSupplier(b -> b.operand(relClass).anyInputs()).as(Config.class);
            }
        }
    }
}

