/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantLongValue;

public interface LongValue
extends LongValueStream,
AnalyticsValue {
    public long getLong();

    public static abstract class AbstractLongValue
    implements CastingLongValue {
        @Override
        public double getDouble() {
            return this.getLong();
        }

        @Override
        public String getString() {
            long val = this.getLong();
            return this.exists() ? Long.toString(val) : null;
        }

        @Override
        public Object getObject() {
            long val = this.getLong();
            return this.exists() ? Long.valueOf(val) : null;
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long val = this.getLong();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double val = this.getDouble();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String val = this.getString();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object val = this.getObject();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public AnalyticsValue convertToConstant() {
            if (this.getExpressionType().equals((Object)AnalyticsValueStream.ExpressionType.CONST)) {
                return new ConstantLongValue(this.getLong());
            }
            return this;
        }

        @Override
        public ExpressionComparator<Long> getObjectComparator(String expression) {
            return new ExpressionComparator<Long>(expression);
        }
    }

    public static interface CastingLongValue
    extends LongValue,
    DoubleValue,
    StringValue,
    ComparableValue {
    }
}

