/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.value.LongValue;

public class LongField
extends AnalyticsField
implements LongValue.CastingLongValue {
    private NumericDocValues docValues;
    private long value;
    private boolean exists;

    public LongField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.exists = this.docValues.advanceExact(doc);
        if (this.exists) {
            this.value = this.docValues.longValue();
        }
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.exists ? Long.toString(this.value) : null;
    }

    @Override
    public Object getObject() {
        return this.exists ? Long.valueOf(this.value) : null;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        if (this.exists) {
            cons.accept(Long.toString(this.value));
        }
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public ExpressionComparator<Long> getObjectComparator(String expression) {
        return new ExpressionComparator<Long>(expression);
    }
}

