/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.filters.TokenFilter;

public class StackTraceFilter {
    private static List defaultFilters = Arrays.asList(Pattern.compile("^(\\s+at )(org\\.junit\\.)"), Pattern.compile("^(\\s+at )(junit\\.framework\\.JUnit4TestAdapter)"), Pattern.compile("^(\\s+at )(sun\\.reflect\\.)"), Pattern.compile("^(\\s+at )(java\\.lang\\.reflect\\.Method\\.invoke\\()"), Pattern.compile("^(\\s+at )(com\\.carrotsearch\\.ant\\.tasks\\.junit4\\.slave\\.SlaveMain)"));
    private boolean useDefaults = true;
    private boolean enabled = true;
    private List customFilters = new ArrayList();

    public void setDefaults(boolean bl) {
        this.useDefaults = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void addContainsString(TokenFilter.ContainsString containsString) {
        this.addConfigured((TokenFilter.Filter)containsString);
    }

    public void addContainsRegex(TokenFilter.ContainsRegex containsRegex) {
        this.addConfigured((TokenFilter.Filter)containsRegex);
    }

    public void addConfigured(TokenFilter.Filter filter) {
        this.customFilters.add(filter);
    }

    public String apply(String string) {
        if (!this.enabled) {
            return string;
        }
        List<String> list = Arrays.asList(string.split("[\r\n]+"));
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string2 : list) {
            if (this.useDefaults) {
                for (Pattern pattern : defaultFilters) {
                    if (!pattern.matcher(string2).find()) continue;
                    continue block0;
                }
            }
            for (Pattern pattern : this.customFilters) {
                if (pattern.filter(string2) == null) continue;
                continue block0;
            }
            arrayList.add(string2);
        }
        return Joiner.on("\n").join(arrayList);
    }
}

