/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry$NonTerminalImmutableMapEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntrySet$RegularEntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.JdkBackedImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap$KeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap$Values;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class RegularImmutableMap
extends ImmutableMap {
    static final ImmutableMap EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    final transient Map.Entry[] entries;
    private final transient ImmutableMapEntry[] table;
    private final transient int mask;

    static ImmutableMap fromEntries(Map.Entry ... entryArray) {
        return RegularImmutableMap.fromEntryArray(entryArray.length, entryArray);
    }

    static ImmutableMap fromEntryArray(int n, Map.Entry[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        Map.Entry[] entryArray2 = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int n2 = Hashing.closedTableSize(n, 1.2);
        ImmutableMapEntry[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n2);
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entryArray[i];
            Object k = entry.getKey();
            Object v = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k, v);
            int n4 = Hashing.smear(k.hashCode()) & n3;
            ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n4];
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntry == null ? RegularImmutableMap.makeImmutable(entry, k, v) : new ImmutableMapEntry$NonTerminalImmutableMapEntry(k, v, immutableMapEntry);
            immutableMapEntryArray[n4] = immutableMapEntry2;
            entryArray2[i] = immutableMapEntry2;
            int n5 = RegularImmutableMap.checkNoConflictInKeyBucket(k, immutableMapEntry2, immutableMapEntry);
            if (n5 <= 8) continue;
            return JdkBackedImmutableMap.create(n, entryArray);
        }
        return new RegularImmutableMap(entryArray2, immutableMapEntryArray, n3);
    }

    static ImmutableMapEntry makeImmutable(Map.Entry entry, Object object, Object object2) {
        boolean bl = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        return bl ? (ImmutableMapEntry)entry : new ImmutableMapEntry(object, object2);
    }

    static ImmutableMapEntry makeImmutable(Map.Entry entry) {
        return RegularImmutableMap.makeImmutable(entry, entry.getKey(), entry.getValue());
    }

    private RegularImmutableMap(Map.Entry[] entryArray, ImmutableMapEntry[] immutableMapEntryArray, int n) {
        this.entries = entryArray;
        this.table = immutableMapEntryArray;
        this.mask = n;
    }

    @CanIgnoreReturnValue
    static int checkNoConflictInKeyBucket(Object object, Map.Entry entry, @NullableDecl ImmutableMapEntry immutableMapEntry) {
        int n = 0;
        while (immutableMapEntry != null) {
            RegularImmutableMap.checkNoConflict(!object.equals(immutableMapEntry.getKey()), "key", entry, immutableMapEntry);
            ++n;
            immutableMapEntry = immutableMapEntry.getNextInKeyBucket();
        }
        return n;
    }

    @Override
    public Object get(@NullableDecl Object object) {
        return RegularImmutableMap.get(object, this.table, this.mask);
    }

    @NullableDecl
    static Object get(@NullableDecl Object object, @NullableDecl ImmutableMapEntry[] immutableMapEntryArray, int n) {
        if (object == null || immutableMapEntryArray == null) {
            return null;
        }
        int n2 = Hashing.smear(object.hashCode()) & n;
        for (ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n2]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInKeyBucket()) {
            Object object2 = immutableMapEntry.getKey();
            if (!object.equals(object2)) continue;
            return immutableMapEntry.getValue();
        }
        return null;
    }

    public void forEach(BiConsumer biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (Map.Entry entry : this.entries) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet createEntrySet() {
        return new ImmutableMapEntrySet$RegularEntrySet((ImmutableMap)this, this.entries);
    }

    @Override
    ImmutableSet createKeySet() {
        return new RegularImmutableMap$KeySet(this);
    }

    @Override
    ImmutableCollection createValues() {
        return new RegularImmutableMap$Values(this);
    }
}

