/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.gimap.protocol;

import com.sun.mail.gimap.GmailFolder;
import com.sun.mail.gimap.protocol.GmailSearchSequence;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.protocol.FetchItem;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.SearchSequence;
import com.sun.mail.util.MailLogger;
import java.io.IOException;
import java.util.Properties;

public class GmailProtocol
extends IMAPProtocol {
    public static final FetchItem MSGID_ITEM = new FetchItem("X-GM-MSGID", GmailFolder.FetchProfileItem.MSGID){

        public Object parseItem(FetchResponse r) {
            return r.readLong();
        }
    };
    public static final FetchItem THRID_ITEM = new FetchItem("X-GM-THRID", GmailFolder.FetchProfileItem.THRID){

        public Object parseItem(FetchResponse r) {
            return r.readLong();
        }
    };
    public static final FetchItem LABELS_ITEM = new FetchItem("X-GM-LABELS", GmailFolder.FetchProfileItem.LABELS){

        public Object parseItem(FetchResponse r) {
            return r.readAtomStringList();
        }
    };
    private static final FetchItem[] myFetchItems = new FetchItem[]{MSGID_ITEM, THRID_ITEM, LABELS_ITEM};
    private FetchItem[] fetchItems = null;

    public GmailProtocol(String name, String host, int port, Properties props, boolean isSSL, MailLogger logger) throws IOException, ProtocolException {
        super(name, host, port, props, isSSL, logger);
        if (!this.hasCapability("X-GM-EXT-1")) {
            logger.fine("WARNING! Not connected to Gmail!");
        } else {
            logger.fine("connected to Gmail");
        }
    }

    public FetchItem[] getFetchItems() {
        if (this.fetchItems != null) {
            return this.fetchItems;
        }
        FetchItem[] sfi = super.getFetchItems();
        if (sfi == null || sfi.length == 0) {
            this.fetchItems = myFetchItems;
        } else {
            this.fetchItems = new FetchItem[sfi.length + myFetchItems.length];
            System.arraycopy(sfi, 0, this.fetchItems, 0, sfi.length);
            System.arraycopy(myFetchItems, 0, this.fetchItems, sfi.length, myFetchItems.length);
        }
        return this.fetchItems;
    }

    protected SearchSequence getSearchSequence() {
        if (this.searchSequence == null) {
            this.searchSequence = new GmailSearchSequence();
        }
        return this.searchSequence;
    }
}

