/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import org.apache.commons.math3.distribution.TriangularDistribution;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TriangularDistributionEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    private static final long serialVersionUID = 1L;

    public TriangularDistributionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length != 3) {
            throw new IOException("Triangular distribution requires three numeric parameters low, mode, high");
        }
        double low = ((Number)values[0]).doubleValue();
        double mode = ((Number)values[1]).doubleValue();
        double high = ((Number)values[2]).doubleValue();
        return new TriangularDistribution(low, mode, high);
    }
}

