/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ToolRunner {
    public static int run(Configuration conf, Tool tool, String[] args) throws Exception {
        if (CallerContext.getCurrent() == null) {
            CallerContext ctx = new CallerContext.Builder("CLI").build();
            CallerContext.setCurrent(ctx);
        }
        if (conf == null) {
            conf = new Configuration();
        }
        GenericOptionsParser parser = new GenericOptionsParser(conf, args);
        tool.setConf(conf);
        String[] toolArgs = parser.getRemainingArgs();
        return tool.run(toolArgs);
    }

    public static int run(Tool tool, String[] args) throws Exception {
        return ToolRunner.run(tool.getConf(), tool, args);
    }

    public static void printGenericCommandUsage(PrintStream out) {
        GenericOptionsParser.printGenericCommandUsage(out);
    }

    public static boolean confirmPrompt(String prompt) throws IOException {
        while (true) {
            int c;
            System.err.print(prompt + " (Y or N) ");
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = System.in.read()) != -1 && c != 13 && c != 10) {
                responseBuilder.append((char)c);
            }
            String response = responseBuilder.toString();
            if (response.equalsIgnoreCase("y") || response.equalsIgnoreCase("yes")) {
                return true;
            }
            if (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no")) {
                return false;
            }
            System.err.println("Invalid input: " + response);
        }
    }
}

