/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.riff;

import com.drew.imaging.FileType;
import com.drew.imaging.TypeChecker;

public class RiffTypeChecker
implements TypeChecker {
    @Override
    public int getByteCount() {
        return 12;
    }

    @Override
    public FileType checkType(byte[] bytes) {
        String firstFour = new String(bytes, 0, 4);
        if (!firstFour.equals("RIFF")) {
            return FileType.Unknown;
        }
        String fourCC = new String(bytes, 8, 4);
        if (fourCC.equals("WAVE")) {
            return FileType.Wav;
        }
        if (fourCC.equals("AVI ")) {
            return FileType.Avi;
        }
        if (fourCC.equals("WEBP")) {
            return FileType.WebP;
        }
        return FileType.Riff;
    }
}

