/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Modify/Bevel/Tests/BevelTest03.js
// Timestamp   : 2011-07-27 15:36:48
// Description : 

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function BevelTest03() {
    TdbTest.call(this, 'scripts/Modify/Bevel/Tests/BevelTest03.js');
}

BevelTest03.prototype = new TdbTest();

BevelTest03.prototype.test00 = function() {
    qDebug('running BevelTest03.test00()...');
    this.setUp();
    this.importFile('scripts/Modify/Bevel/Tests/data/2arcs.dxf');
    TdbTest.clickOnWidget('MainWindow::CadToolBar::MainToolsPanel::ModifyToolsPanelButton');
    TdbTest.clickOnWidget('MainWindow::CadToolBar::ModifyToolsPanel::BevelButton');
    this.setToolOption('Bevel/Trim', 'true');
    this.setToolOption('Bevel/Length1',  [ 10, 0 ] );
    this.setToolOption('Bevel/Length2',  [ 16, 0 ] );
    this.updateToolOptions();
    this.setZoom(22.90991020272387, new RVector(-3.93095, -6.52246, 0) );
    var p = new RVector(16.501932, 7.831936);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(22.90991020272387, new RVector(-3.93095, -6.52246, 0) );
    var p = new RVector(7.815734, 17.609364);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    var p = new RVector(10.521987, 14.684866);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.RightButton, 2, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.RightButton, 0, 0);
    this.verifyDrawing('BevelTest03_000.dxf');
    this.tearDown();
    qDebug('finished BevelTest03.test00()');
};

