/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(ivec2(-5, -2)) => ivec2(5, 2)
 * abs(ivec2(-1, 0)) => ivec2(1, 0)
 * abs(ivec2(1, 2)) => ivec2(1, 2)
 * abs(ivec2(5, -5)) => ivec2(5, 5)
 */
#version 150

void main()
{
  float[all(equal(abs(ivec2(-5, -2)), ivec2(5, 2))) ? 1 : -1] array0;
  float[all(equal(abs(ivec2(-1, 0)), ivec2(1, 0))) ? 1 : -1] array1;
  float[all(equal(abs(ivec2(1, 2)), ivec2(1, 2))) ? 1 : -1] array2;
  float[all(equal(abs(ivec2(5, -5)), ivec2(5, 5))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
