/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf - dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(1.3333333333333333lf, 0.85lf, 0.94lf)
 * (0.0lf - dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(-1.67lf, -0.66lf, -1.87lf)
 * (-1.3333333333333333lf - dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(0.0lf, -0.4833333333333333lf, -0.3933333333333333lf)
 * (-1.3333333333333333lf - dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(-3.003333333333333lf, -1.9933333333333332lf, -3.203333333333333lf)
 * (0.85lf - dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(2.183333333333333lf, 1.7lf, 1.79lf)
 * (0.85lf - dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(-0.82lf, 0.18999999999999995lf, -1.02lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf - dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(1.3333333333333333lf, 0.85lf, 0.94lf)) <= 1.839531945299613e-05lf ? 1 : -1] array0;
  double[distance((0.0lf - dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(-1.67lf, -0.66lf, -1.87lf)) <= 2.5925662961629354e-05lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf - dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(0.0lf, -0.4833333333333333lf, -0.3933333333333333lf)) <= 6.2315505471930685e-06lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf - dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(-3.003333333333333lf, -1.9933333333333332lf, -3.203333333333333lf)) <= 4.822316179320196e-05lf ? 1 : -1] array3;
  double[distance((0.85lf - dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(2.183333333333333lf, 1.7lf, 1.79lf)) <= 3.295609874430595e-05lf ? 1 : -1] array4;
  double[distance((0.85lf - dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(-0.82lf, 0.18999999999999995lf, -1.02lf)) <= 1.3224598292575847e-05lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
