/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.actions.AbstractActionProvider;
import org.netbeans.modules.php.dbgp.annotations.CurrentLineAnnotation;
import org.netbeans.modules.php.dbgp.annotations.DebuggerAnnotation;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.models.CallStackModel;
import org.netbeans.modules.php.dbgp.models.ThreadsModel;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.WatchesModel;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public abstract class AbstractIDEBridge {
    public static final String LOCALS_VIEW_NAME = "LocalsView";
    public static final String CALLSTACK_VIEW_NAME = "CallStackView";
    public static final String WATCHES_VIEW_NAME = "WatchesView";
    public static final String BREAKPOINTS_VIEW_NAME = "BreakpointsView";
    public static final String THREADS_VIEW_NAME = "ThreadsView";
    private Map<String, List<DebuggerAnnotation>> myAnnotations = new HashMap<String, List<DebuggerAnnotation>>();
    private AtomicBoolean isSuspended = new AtomicBoolean(false);

    protected AbstractIDEBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAnnotations() {
        ArrayList<List<DebuggerAnnotation>> annotations;
        Map<String, List<DebuggerAnnotation>> map = this.myAnnotations;
        synchronized (map) {
            annotations = new ArrayList<List<DebuggerAnnotation>>(this.myAnnotations.values());
            this.myAnnotations.clear();
        }
        for (List list : annotations) {
            for (DebuggerAnnotation annotation : list) {
                annotation.detach();
            }
        }
    }

    public void showCurrentDebuggerLine(final Line line) {
        if (line != null) {
            this.annotate(new CurrentLineAnnotation((Annotatable)line));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(DebuggerAnnotation annotation) {
        String type = annotation.getAnnotationType();
        Map<String, List<DebuggerAnnotation>> map = this.myAnnotations;
        synchronized (map) {
            List<DebuggerAnnotation> list = this.myAnnotations.get(type);
            if (list == null) {
                list = new LinkedList<DebuggerAnnotation>();
                this.myAnnotations.put(type, list);
            }
            list.add(annotation);
        }
    }

    public VariablesModel getVariablesModel() {
        DebuggerEngine engine = this.getEngine();
        if (engine == null) {
            return null;
        }
        return (VariablesModel)engine.lookupFirst(LOCALS_VIEW_NAME, TreeModel.class);
    }

    public CallStackModel getCallStackModel() {
        DebuggerEngine engine = this.getEngine();
        if (engine == null) {
            return null;
        }
        return (CallStackModel)engine.lookupFirst(CALLSTACK_VIEW_NAME, TreeModel.class);
    }

    public WatchesModel getWatchesModel() {
        DebuggerEngine engine = this.getEngine();
        if (engine == null) {
            return null;
        }
        return (WatchesModel)engine.lookupFirst(WATCHES_VIEW_NAME, TreeModel.class);
    }

    public BreakpointModel getBreakpointModel() {
        Iterator it;
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Iterator iterator = it = debuggerManager != null ? debuggerManager.lookup(BREAKPOINTS_VIEW_NAME, NodeModel.class).iterator() : null;
        while (it != null && it.hasNext()) {
            NodeModel model = (NodeModel)it.next();
            if (!(model instanceof BreakpointModel)) continue;
            return (BreakpointModel)model;
        }
        return null;
    }

    public ThreadsModel getThreadsModel() {
        DebuggerEngine engine = this.getEngine();
        if (engine == null) {
            return null;
        }
        return (ThreadsModel)engine.lookupFirst(THREADS_VIEW_NAME, TreeModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean flag) {
        this.isSuspended.set(flag);
        SessionManager sessionManager = SessionManager.getInstance();
        synchronized (sessionManager) {
            SessionId id = this.getDebugSession().getSessionId();
            if (id == null) {
                return;
            }
            DebugSession current = SessionManager.getInstance().getSession(id);
            if (current != null && !current.equals(this.getDebugSession())) {
                return;
            }
        }
        DebuggerEngine engine = this.getEngine();
        List list = engine != null ? engine.lookup(null, ActionsProvider.class) : Collections.emptyList();
        for (Object object : list) {
            assert (object instanceof AbstractActionProvider);
            AbstractActionProvider provider = (AbstractActionProvider)((Object)object);
            Set set = provider.getActions();
            for (Object obj : set) {
                if (obj != ActionsManager.ACTION_CONTINUE && obj != ActionsManager.ACTION_STEP_INTO && obj != ActionsManager.ACTION_STEP_OVER && obj != ActionsManager.ACTION_STEP_OUT && obj != ActionsManager.ACTION_RUN_TO_CURSOR) continue;
                provider.setEnabled(flag);
            }
        }
    }

    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    protected abstract DebuggerEngine getEngine();

    protected abstract DebugSession getDebugSession();
}

