/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.IntStream;
import jdk.jshell.execution.DefaultLoaderDelegate;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.SPIResolutionException;

public class DirectExecutionControl
implements ExecutionControl {
    private static final String[] charRep = new String[256];
    private final LoaderDelegate loaderDelegate;

    public DirectExecutionControl(LoaderDelegate loaderDelegate) {
        this.loaderDelegate = loaderDelegate;
    }

    public DirectExecutionControl() {
        this(new DefaultLoaderDelegate());
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.NotImplementedException, ExecutionControl.EngineTerminationException {
        this.loaderDelegate.load(cbcs);
    }

    @Override
    public void redefine(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.NotImplementedException, ExecutionControl.EngineTerminationException {
        throw new ExecutionControl.NotImplementedException("redefine not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String invoke(String className, String methodName) throws ExecutionControl.RunException, ExecutionControl.InternalException, ExecutionControl.EngineTerminationException {
        Method doitMethod;
        try {
            Class<?> klass = this.findClass(className);
            doitMethod = klass.getDeclaredMethod(methodName, new Class[0]);
            doitMethod.setAccessible(true);
        }
        catch (Throwable ex) {
            throw new ExecutionControl.InternalException(ex.toString());
        }
        try {
            this.clientCodeEnter();
            String result = this.invoke(doitMethod);
            System.out.flush();
            String string = result;
            return string;
        }
        catch (ExecutionControl.EngineTerminationException | ExecutionControl.InternalException | ExecutionControl.RunException ex) {
            throw ex;
        }
        catch (SPIResolutionException ex) {
            String string = this.throwConvertedInvocationException(ex);
            return string;
        }
        catch (InvocationTargetException ex) {
            String string = this.throwConvertedInvocationException(ex.getCause());
            return string;
        }
        catch (Throwable ex) {
            String string = this.throwConvertedOtherException(ex);
            return string;
        }
        finally {
            this.clientCodeLeave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String varValue(String className, String varName) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        Object val;
        try {
            Class<?> klass = this.findClass(className);
            Field var = klass.getDeclaredField(varName);
            var.setAccessible(true);
            val = var.get(null);
        }
        catch (Throwable ex) {
            throw new ExecutionControl.InternalException(ex.toString());
        }
        try {
            this.clientCodeEnter();
            String ex = DirectExecutionControl.valueString(val);
            return ex;
        }
        catch (Throwable ex) {
            String string = this.throwConvertedInvocationException(ex);
            return string;
        }
        finally {
            this.clientCodeLeave();
        }
    }

    @Override
    public void addToClasspath(String cp) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        this.loaderDelegate.addToClasspath(cp);
    }

    @Override
    public void stop() throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        throw new ExecutionControl.NotImplementedException("stop: Not supported.");
    }

    @Override
    public Object extensionCommand(String command, Object arg) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        throw new ExecutionControl.NotImplementedException("Unknown command: " + command);
    }

    @Override
    public void close() {
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.loaderDelegate.findClass(name);
    }

    protected String invoke(Method doitMethod) throws Exception {
        Object res = doitMethod.invoke(null, new Object[0]);
        return DirectExecutionControl.valueString(res);
    }

    protected static String valueString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + ((String)value).codePoints().flatMap(cp -> cp == 34 ? "\\\"".codePoints() : (cp < 256 ? charRep[cp].codePoints() : IntStream.of(cp))).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString() + "\"";
        }
        if (value instanceof Character) {
            char cp2 = ((Character)value).charValue();
            return "'" + (cp2 == '\'' ? "\\'" : (cp2 < '\u0100' ? charRep[cp2] : String.valueOf(cp2))) + "'";
        }
        if (value.getClass().isArray()) {
            int i;
            Class<?> ct;
            int dims = 0;
            Class<?> t = value.getClass();
            while ((ct = t.getComponentType()) != null) {
                ++dims;
                t = ct;
            }
            String tn = t.getTypeName();
            int len = Array.getLength(value);
            StringBuilder sb = new StringBuilder();
            sb.append(tn.substring(tn.lastIndexOf(46) + 1, tn.length()));
            sb.append("[");
            sb.append(len);
            sb.append("]");
            for (i = 1; i < dims; ++i) {
                sb.append("[]");
            }
            sb.append(" { ");
            for (i = 0; i < len; ++i) {
                sb.append(DirectExecutionControl.valueString(Array.get(value, i)));
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            return sb.toString();
        }
        return value.toString();
    }

    protected String throwConvertedInvocationException(Throwable cause) throws ExecutionControl.RunException, ExecutionControl.InternalException {
        if (cause instanceof SPIResolutionException) {
            SPIResolutionException spire = (SPIResolutionException)cause;
            throw new ExecutionControl.ResolutionException(spire.id(), spire.getStackTrace());
        }
        throw new ExecutionControl.UserException(cause.getMessage(), cause.getClass().getName(), cause.getStackTrace());
    }

    protected String throwConvertedOtherException(Throwable ex) throws ExecutionControl.RunException, ExecutionControl.InternalException {
        throw new ExecutionControl.InternalException(ex.toString());
    }

    protected void clientCodeEnter() throws ExecutionControl.InternalException {
    }

    protected void clientCodeLeave() throws ExecutionControl.InternalException {
    }

    static {
        for (int i = 0; i < charRep.length; ++i) {
            DirectExecutionControl.charRep[i] = Character.isISOControl(i) ? String.format("\\%03o", i) : "" + (char)i;
        }
        DirectExecutionControl.charRep[8] = "\\b";
        DirectExecutionControl.charRep[9] = "\\t";
        DirectExecutionControl.charRep[10] = "\\n";
        DirectExecutionControl.charRep[12] = "\\f";
        DirectExecutionControl.charRep[13] = "\\r";
        DirectExecutionControl.charRep[92] = "\\\\";
    }
}

