/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingActionsProvider;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private JPDADebugger debugger;
    private ContextProvider lookupProvider;
    private final Action POP_TO_HERE_ACTION;
    private final Action MAKE_CURRENT_ACTION;
    private final Action COPY_TO_CLBD_ACTION;
    private final Action GO_TO_SOURCE_ACTION;
    private final Action ADD_BREAKPOINT_ACTION;

    public CallStackActionsProvider(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        RequestProcessor requestProcessor = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.POP_TO_HERE_ACTION = DebuggingActionsProvider.createPOP_TO_HERE_ACTION(requestProcessor);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(requestProcessor);
        this.COPY_TO_CLBD_ACTION = this.createCOPY_TO_CLBD_ACTION(requestProcessor);
        this.GO_TO_SOURCE_ACTION = DebuggingActionsProvider.createGO_TO_SOURCE_ACTION(requestProcessor);
        this.ADD_BREAKPOINT_ACTION = DebuggingActionsProvider.createBREAKPOINT(requestProcessor);
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                return true;
            }

            @Override
            public void run(Object[] nodes) {
                CallStackActionsProvider.this.makeCurrent((CallStackFrame)nodes[0]);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createCOPY_TO_CLBD_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(CallStackActionsProvider.class).getString("CTL_CallstackAction_Copy2CLBD_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                JPDAThread t = CallStackActionsProvider.this.debugger.getCurrentThread();
                return t != null && t.isSuspended();
            }

            @Override
            public void run(Object[] nodes) {
                CallStackActionsProvider.this.stackToCLBD();
            }
        }, (int)Models.MULTISELECTION_TYPE_ANY);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{this.COPY_TO_CLBD_ACTION};
        }
        if (!(node instanceof CallStackFrame)) {
            throw new UnknownTypeException(node);
        }
        boolean popToHere = this.debugger.canPopFrames();
        if (popToHere) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION, this.ADD_BREAKPOINT_ACTION, this.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
        }
        return new Action[]{this.MAKE_CURRENT_ACTION, this.ADD_BREAKPOINT_ACTION, this.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
    }

    public void performDefaultAction(final Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof CallStackFrame) {
            ((RequestProcessor)this.lookupProvider.lookupFirst(null, RequestProcessor.class)).post(new Runnable(){

                @Override
                public void run() {
                    CallStackActionsProvider.this.makeCurrent((CallStackFrame)node);
                }
            });
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private void stackToCLBD() {
        JPDAThread t = this.debugger.getCurrentThread();
        if (t == null) {
            return;
        }
        StringBuffer frameStr = new StringBuffer(50);
        DebuggingActionsProvider.appendStackInfo(frameStr, t);
        Clipboard systemClipboard = DebuggingActionsProvider.getClipboard();
        StringSelection transferableText = new StringSelection(frameStr.toString());
        systemClipboard.setContents(transferableText, null);
    }

    private void makeCurrent(CallStackFrame frame) {
        if (this.debugger.getCurrentCallStackFrame() != frame) {
            frame.makeCurrent();
        } else {
            Session session;
            try {
                session = (Session)this.debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)this.debugger, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                session = DebuggerManager.getDebuggerManager().getCurrentSession();
            }
            if (session == null) {
                return;
            }
            String language = session.getCurrentLanguage();
            SourcePath sp = (SourcePath)session.getCurrentEngine().lookupFirst(null, SourcePath.class);
            if (sp == null) {
                return;
            }
            sp.showSource(frame, language);
        }
    }
}

