/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;

public class DebugTooling {
    final String buildDir;

    public DebugTooling(String buildDir) {
        this.buildDir = buildDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NbProjectInfo loadInfo(File project, String ... extraArgs) {
        NbProjectInfo ret = null;
        GradleConnector gconn = GradleConnector.newConnector();
        ProjectConnection pconn = gconn.forProjectDirectory(project).connect();
        BuildActionExecuter action = pconn.action((BuildAction)new NbProjectInfoAction());
        action.setJvmArguments(new String[]{"-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5006", "-DNETBEANS_TOOLING_JAR=" + this.buildDir + "/libs/netbeans-gradle-tooling.jar"});
        ArrayList<String> args = new ArrayList<String>();
        args.add("-I");
        args.add(this.buildDir + "/resources/main/nb-tooling.gradle");
        args.addAll(Arrays.asList(extraArgs));
        action.withArguments(args.toArray(new String[args.size()]));
        try {
            ret = (NbProjectInfo)action.run();
        }
        catch (IllegalStateException | GradleConnectionException ex) {
            System.err.println("Failed to retrieve project information for: " + project);
            ex.printStackTrace();
        }
        finally {
            try {
                pconn.close();
            }
            catch (NullPointerException nullPointerException) {}
        }
        return ret;
    }

    public static void main(String[] args) {
        DebugTooling dt;
        NbProjectInfo info;
        String buildDir;
        File projectDir;
        if (args.length == 0) {
            System.err.println("Usage: java -jar netbeans-gradle-tooling.jar <project dir> [<gradle args>...]");
            System.exit(1);
        }
        if (!(projectDir = new File(args[0])).isDirectory()) {
            System.err.println("Project not found at: " + projectDir.getAbsolutePath());
            System.exit(1);
        }
        if (!new File(buildDir = System.getProperty("user.dir") + "/build").isDirectory()) {
            System.err.println("This tool can be executed from it's project dir only");
            System.exit(1);
        }
        if ((info = (dt = new DebugTooling(buildDir)).loadInfo(projectDir, Arrays.copyOfRange(args, 1, args.length))).hasException()) {
            System.err.println(info.getGradleException());
        } else {
            System.out.println(info);
        }
    }

    private static class NbProjectInfoAction
    implements Serializable,
    BuildAction<NbProjectInfo> {
        private NbProjectInfoAction() {
        }

        public NbProjectInfo execute(BuildController bc) {
            return (NbProjectInfo)bc.getModel(NbProjectInfo.class);
        }
    }
}

