/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.other;

import java.util.Collections;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.csl.api.CslActions;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.hints.other.Bundle;

public class SurroundWithTag
extends Hint {
    private static final Rule RULE = new SurroundWithTagRule();

    public SurroundWithTag(RuleContext context, OffsetRange range) {
        super(RULE, Bundle.MSG_SurroundWithTag(), context.parserResult.getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new SurroundWithTagHintFix(context)), 10);
    }

    private static class SurroundWithTagRule
    implements Rule {
        private SurroundWithTagRule() {
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return Bundle.MSG_SurroundWithTag();
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.INFO;
        }
    }

    private static class SurroundWithTagHintFix
    implements HintFix {
        private static final String OPEN_TAG = "<div>";
        private static final String CLOSE_TAG = "</div>";
        RuleContext context;

        public SurroundWithTagHintFix(RuleContext context) {
            this.context = context;
        }

        public String getDescription() {
            return Bundle.MSG_SurroundWithTag();
        }

        public void implement() throws Exception {
            this.context.doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        context.doc.insertString(context.selectionStart, SurroundWithTagHintFix.OPEN_TAG, null);
                        context.doc.insertString(context.selectionEnd + SurroundWithTagHintFix.OPEN_TAG.length(), SurroundWithTagHintFix.CLOSE_TAG, null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JTextComponent pane = EditorRegistry.focusedComponent();
                                pane.select(context.selectionStart + 1, context.selectionStart + 2);
                                pane.setCaretPosition(context.selectionStart + 1);
                                BaseAction instantRenameAction = (BaseAction)CslActions.createInstantRenameAction();
                                instantRenameAction.actionPerformed(null, pane);
                            }
                        });
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

