/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

public class VMWrapper {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};

    private VMWrapper() {
    }

    public static String[] getRuntimeArguments() {
        return new String[0];
    }

    public static Path findCtSym() {
        try {
            Enumeration<URL> en;
            URL res;
            ClassLoader loader = VMWrapper.class.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            URL uRL = res = (en = loader.getResources("META-INF/services/com.sun.tools.javac.platform.PlatformProvider")).hasMoreElements() ? en.nextElement() : null;
            if (res == null) {
                String javaHome = System.getProperty("java.home");
                Path file = Paths.get(javaHome, new String[0]);
                for (String name : symbolFileLocation) {
                    file = file.resolve(name);
                }
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new IllegalStateException("Cannot find ct.sym at " + file);
                }
                return FileSystems.newFileSystem(file, (ClassLoader)null).getRootDirectories().iterator().next();
            }
            if (!res.getProtocol().equals("jar")) {
                res = en.hasMoreElements() ? en.nextElement() : null;
            }
            URL jar = ((JarURLConnection)res.openConnection()).getJarFileURL();
            Path path = Paths.get(jar.toURI());
            FileSystem fs = FileSystems.newFileSystem(path, (ClassLoader)null);
            return fs.getPath("META-INF", "ct.sym");
        }
        catch (IOException | URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) throws IOException {
        final ArrayList<Path> all = new ArrayList<Path>();
        for (Path ch : Files.newDirectoryStream(dir)) {
            String fileName = ch.getFileName().toString();
            if (fileName.endsWith("/")) {
                all.add(dir.resolve(fileName.substring(0, fileName.length() - 1)));
                continue;
            }
            all.add(ch);
        }
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return all.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    public static FileSystem pathFs(final Path p) {
        return new FileSystem(){

            @Override
            public FileSystemProvider provider() {
                return p.getFileSystem().provider();
            }

            @Override
            public void close() throws IOException {
                p.getFileSystem().close();
            }

            @Override
            public boolean isOpen() {
                return p.getFileSystem().isOpen();
            }

            @Override
            public boolean isReadOnly() {
                return p.getFileSystem().isReadOnly();
            }

            @Override
            public String getSeparator() {
                return p.getFileSystem().getSeparator();
            }

            @Override
            public Iterable<Path> getRootDirectories() {
                return Collections.singleton(p);
            }

            @Override
            public Iterable<FileStore> getFileStores() {
                return p.getFileSystem().getFileStores();
            }

            @Override
            public Set<String> supportedFileAttributeViews() {
                return p.getFileSystem().supportedFileAttributeViews();
            }

            @Override
            public Path getPath(String first, String ... more) {
                Path r = p.resolve(first);
                for (String m : more) {
                    r = r.resolve(m);
                }
                return r;
            }

            @Override
            public PathMatcher getPathMatcher(String syntaxAndPattern) {
                return p.getFileSystem().getPathMatcher(syntaxAndPattern);
            }

            @Override
            public UserPrincipalLookupService getUserPrincipalLookupService() {
                return p.getFileSystem().getUserPrincipalLookupService();
            }

            @Override
            public WatchService newWatchService() throws IOException {
                return p.getFileSystem().newWatchService();
            }
        };
    }
}

