/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConnectionRequest
extends BmcRequest<Void> {
    private String connectionId;
    private String opcRequestId;

    @ConstructorProperties(value={"connectionId", "opcRequestId"})
    GetConnectionRequest(String connectionId, String opcRequestId) {
        this.connectionId = connectionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().connectionId(this.connectionId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetConnectionRequest(super=" + super.toString() + ", connectionId=" + this.getConnectionId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetConnectionRequest)) {
            return false;
        }
        GetConnectionRequest other = (GetConnectionRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetConnectionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConnectionRequest, Void> {
        private String connectionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConnectionRequest o) {
            this.connectionId(o.getConnectionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConnectionRequest build() {
            GetConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetConnectionRequest buildWithoutInvocationCallback() {
            return new GetConnectionRequest(this.connectionId, this.opcRequestId);
        }

        public String toString() {
            return "GetConnectionRequest.Builder(connectionId=" + this.connectionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

