/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class SettingsType {
    private static final Logger LOG = Logger.getLogger(SettingsType.class.getName());

    public static <K, V> StorageDescription<K, V> find(String id) {
        assert (id != null) : "The parameter id can't be null";
        StorageDescription sd = Cache.getInstance().find(id);
        return sd;
    }

    public static Locator getLocator(StorageDescription sd) {
        assert (sd != null) : "The parameter sd can't be null";
        Collection locators = Lookup.getDefault().lookupAll(LocatorFactory.class);
        for (LocatorFactory f : locators) {
            Locator l = f.createLocator(sd);
            if (l == null) continue;
            return l;
        }
        if ("Preferences".equals(sd.getId())) {
            return new PreferencesLocator(sd.getId(), sd.isUsingProfiles(), sd.getMimeType(), sd.getLegacyFileName());
        }
        return new DefaultLocator(sd.getId(), sd.isUsingProfiles(), sd.getMimeType(), sd.getLegacyFileName());
    }

    private SettingsType() {
    }

    private static final class PreferencesLocator
    extends DefaultLocator {
        public PreferencesLocator(String settingTypeId, boolean hasProfiles, String mimeType, String legacyFileName) {
            super(settingTypeId, hasProfiles, mimeType, legacyFileName);
        }

        @Override
        protected FileObject getLegacyMimeFolder(FileObject baseFolder, String mimeType) {
            if (mimeType == null || mimeType.length() == 0) {
                return baseFolder.getFileObject("text/base");
            }
            return super.getMimeFolder(baseFolder, mimeType);
        }
    }

    public static class DefaultLocator
    implements Locator {
        protected static final String MODULE_FILES_FOLDER = "Defaults";
        protected static final String DEFAULT_PROFILE_NAME = "NetBeans";
        private static final String WRITABLE_FILE_PREFIX = "org-netbeans-modules-editor-settings-Custom";
        private static final String WRITABLE_FILE_SUFFIX = ".xml";
        private static final String FA_TARGET_OS = "nbeditor-settings-targetOS";
        private static final String LINK_EXTENSION = "shadow";
        protected final String settingTypeId;
        protected final boolean isUsingProfiles;
        protected final String mimeType;
        protected final String legacyFileName;
        protected final String writableFilePrefix;
        protected final String modulesWritableFilePrefix;
        protected final ThreadLocal<FileObject> threadsBaseFolder = new ThreadLocal();

        public DefaultLocator(String settingTypeId, boolean hasProfiles, String mimeType, String legacyFileName) {
            this.settingTypeId = settingTypeId;
            this.isUsingProfiles = hasProfiles;
            this.mimeType = mimeType;
            this.legacyFileName = legacyFileName;
            this.writableFilePrefix = WRITABLE_FILE_PREFIX + settingTypeId;
            this.modulesWritableFilePrefix = "Defaults/" + this.writableFilePrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void scan(FileObject baseFolder, String mimeType, String profileId, boolean fullScan, boolean scanModules, boolean scanUsers, boolean resolveLinks, Map<String, List<Object[]>> results) {
            assert (results != null) : "The parameter results can't be null";
            this.threadsBaseFolder.set(baseFolder);
            try {
                FileObject mimeFolder = null;
                FileObject legacyMimeFolder = null;
                if (baseFolder != null) {
                    mimeFolder = this.getMimeFolder(baseFolder, mimeType);
                    legacyMimeFolder = this.getLegacyMimeFolder(baseFolder, mimeType);
                }
                if (scanModules) {
                    if (legacyMimeFolder != null && legacyMimeFolder.isFolder()) {
                        this.addModulesLegacyFiles(legacyMimeFolder, profileId, fullScan, results);
                    }
                    if (mimeFolder != null && mimeFolder.isFolder()) {
                        this.addModulesFiles(mimeFolder, profileId, fullScan, results, resolveLinks);
                    }
                }
                if (scanUsers) {
                    if (legacyMimeFolder != null && legacyMimeFolder.isFolder()) {
                        this.addUsersLegacyFiles(legacyMimeFolder, profileId, fullScan, results);
                    }
                    if (mimeFolder != null && mimeFolder.isFolder()) {
                        this.addUsersFiles(mimeFolder, profileId, fullScan, results);
                    }
                }
            }
            finally {
                this.threadsBaseFolder.remove();
            }
        }

        @Override
        public final String getWritableFileName(String mimeType, String profileId, String fileId, boolean modulesFile) {
            StringBuilder part = new StringBuilder(127);
            if (mimeType == null || mimeType.length() == 0) {
                part.append(this.settingTypeId).append('/');
            } else {
                part.append(mimeType).append('/').append(this.settingTypeId).append('/');
            }
            if (this.isUsingProfiles) {
                assert (profileId != null) : "The profileId parameter must not be null";
                part.append(profileId).append('/');
            }
            if (modulesFile) {
                part.append(this.modulesWritableFilePrefix);
            } else {
                part.append(this.writableFilePrefix);
            }
            if (fileId != null && fileId.length() != 0) {
                part.append(fileId);
            }
            part.append(WRITABLE_FILE_SUFFIX);
            return part.toString();
        }

        @Override
        public final boolean isUsingProfiles() {
            return this.isUsingProfiles;
        }

        protected FileObject getLegacyMimeFolder(FileObject baseFolder, String mimeType) {
            return mimeType == null ? baseFolder : baseFolder.getFileObject(mimeType);
        }

        protected void addModulesLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            if (this.legacyFileName != null) {
                this.addLegacyFiles(mimeFolder, profileId, "Defaults/" + this.legacyFileName, files, true);
            }
        }

        protected void addUsersLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            if (this.legacyFileName != null) {
                this.addLegacyFiles(mimeFolder, profileId, this.legacyFileName, files, true);
            }
        }

        protected FileObject getMimeFolder(FileObject baseFolder, String mimeType) {
            return mimeType == null ? baseFolder : baseFolder.getFileObject(mimeType);
        }

        private void addModulesFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files, boolean resolveLinks) {
            if (profileId == null) {
                FileObject settingHome = mimeFolder.getFileObject(this.settingTypeId);
                if (settingHome != null && settingHome.isFolder()) {
                    if (this.isUsingProfiles) {
                        FileObject[] profileHomes;
                        for (FileObject f : profileHomes = settingHome.getChildren()) {
                            if (!f.isFolder()) continue;
                            String id = f.getNameExt();
                            FileObject folder = f.getFileObject(MODULE_FILES_FOLDER);
                            if (folder == null || !folder.isFolder()) continue;
                            this.addFiles(folder, fullScan, files, id, f, true, resolveLinks);
                        }
                    } else {
                        FileObject folder = settingHome.getFileObject(MODULE_FILES_FOLDER);
                        if (folder != null && folder.isFolder()) {
                            this.addFiles(folder, fullScan, files, null, null, true, resolveLinks);
                        }
                    }
                }
            } else {
                FileObject folder = mimeFolder.getFileObject(this.settingTypeId + "/" + profileId + "/" + MODULE_FILES_FOLDER);
                if (folder != null && folder.isFolder()) {
                    this.addFiles(folder, fullScan, files, profileId, folder.getParent(), true, resolveLinks);
                }
            }
        }

        private void addUsersFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            if (profileId == null) {
                FileObject settingHome = mimeFolder.getFileObject(this.settingTypeId);
                if (settingHome != null && settingHome.isFolder()) {
                    if (this.isUsingProfiles) {
                        FileObject[] profileHomes;
                        for (FileObject f : profileHomes = settingHome.getChildren()) {
                            if (!f.isFolder()) continue;
                            String id = f.getNameExt();
                            this.addFiles(f, fullScan, files, id, f, false, false);
                        }
                    } else {
                        this.addFiles(settingHome, fullScan, files, null, null, false, false);
                    }
                }
            } else {
                FileObject folder = mimeFolder.getFileObject(this.settingTypeId + "/" + profileId);
                if (folder != null && folder.isFolder()) {
                    this.addFiles(folder, fullScan, files, profileId, folder, false, false);
                }
            }
        }

        private final void addFiles(FileObject folder, boolean fullScan, Map<String, List<Object[]>> files, String profileId, FileObject profileHome, boolean moduleFiles, boolean resolveLinks) {
            List<Object[]> infos;
            ArrayList<Object[]> writableFiles = new ArrayList<Object[]>();
            ArrayList<Object[]> osSpecificFiles = new ArrayList<Object[]>();
            List ff = FileUtil.getOrder(Arrays.asList(folder.getChildren()), (boolean)false);
            for (FileObject f : ff) {
                Object[] oo;
                List<Object[]> infos2;
                if (!f.isData()) continue;
                if (resolveLinks && LINK_EXTENSION.equals(f.getExt())) {
                    FileObject linkTarget = this.resolveLink(f);
                    if (linkTarget == null) continue;
                    infos2 = files.get(profileId);
                    if (infos2 == null) {
                        infos2 = new ArrayList<Object[]>();
                        files.put(profileId, infos2);
                    }
                    oo = new Object[]{profileHome, f, true, linkTarget, false};
                    infos2.add(oo);
                    continue;
                }
                if (this.mimeType.equals(FileUtil.getMIMEType((FileObject)f, (String[])new String[]{this.mimeType}))) {
                    Object targetOs;
                    block17: {
                        targetOs = f.getAttribute(FA_TARGET_OS);
                        if (targetOs != null) {
                            try {
                                if (!this.isApplicableForThisTargetOs(targetOs)) {
                                    LOG.fine("Ignoring OS specific file: '" + f.getPath() + "', it's targetted for '" + targetOs + "'");
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                LOG.log(Level.WARNING, "Ignoring editor settings file with invalid OS type mask '" + targetOs + "' file: '" + f.getPath() + "'");
                            }
                            continue;
                        }
                    }
                    if ((infos2 = files.get(profileId)) == null) {
                        infos2 = new ArrayList<Object[]>();
                        files.put(profileId, infos2);
                    }
                    oo = new Object[]{profileHome, f, moduleFiles, null, false};
                    if (moduleFiles) {
                        if (f.getNameExt().startsWith(this.writableFilePrefix)) {
                            writableFiles.add(oo);
                        } else if (targetOs != null) {
                            osSpecificFiles.add(oo);
                        } else {
                            infos2.add(oo);
                        }
                    } else {
                        infos2.add(oo);
                    }
                    if (fullScan) continue;
                    break;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Ignoring file: '" + f.getPath() + "' of type " + f.getMIMEType());
            }
            if (!osSpecificFiles.isEmpty()) {
                infos = files.get(profileId);
                infos.addAll(osSpecificFiles);
            }
            if (!writableFiles.isEmpty()) {
                infos = files.get(profileId);
                infos.addAll(writableFiles);
            }
        }

        private boolean isApplicableForThisTargetOs(Object targetOs) throws NoSuchFieldException, IllegalAccessException {
            if (targetOs instanceof Boolean) {
                return (Boolean)targetOs;
            }
            if (targetOs instanceof String) {
                Field field = BaseUtilities.class.getDeclaredField((String)targetOs);
                int targetOsMask = field.getInt(null);
                int currentOsId = BaseUtilities.getOperatingSystem();
                return (currentOsId & targetOsMask) != 0;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileObject resolveLink(FileObject link) {
            FileObject targetFile;
            block24: {
                String targetFilePath = null;
                String targetFilesystem = null;
                if (link.getSize() == 0L) {
                    Object fileName = link.getAttribute("originalFile");
                    if (fileName instanceof String) {
                        targetFilePath = (String)fileName;
                    } else if (fileName instanceof URL) {
                        targetFilePath = ((URL)fileName).toExternalForm();
                    } else {
                        LOG.warning("Invalid originalFile '" + fileName + "', ignoring editor settings link " + link.getPath());
                    }
                    Object filesystemName = link.getAttribute("originalFileSystem");
                    if (filesystemName instanceof String) {
                        targetFilesystem = (String)filesystemName;
                    }
                } else {
                    try (BufferedReader ois = new BufferedReader(new InputStreamReader(link.getInputStream(), StandardCharsets.UTF_8));){
                        targetFilePath = ois.readLine();
                        targetFilesystem = ois.readLine();
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.WARNING, "Can't read editor settings link, ignoring " + link.getPath(), ioe);
                        targetFilePath = null;
                    }
                }
                if (targetFilesystem != null && !targetFilesystem.equals("SystemFileSystem")) {
                    LOG.warning("Editor settings links can only link targets on SystemFileSystem, ignoring link " + link.getPath());
                    targetFilePath = null;
                }
                targetFile = null;
                if (targetFilePath != null) {
                    URI u;
                    try {
                        u = new URI(targetFilePath);
                    }
                    catch (URISyntaxException e) {
                        u = null;
                    }
                    if (u != null && u.isAbsolute()) {
                        try {
                            FileObject ff = URLMapper.findFileObject((URL)u.toURL());
                            if (ff == null) break block24;
                            if (ff.getFileSystem().isDefault()) {
                                targetFile = ff;
                                break block24;
                            }
                            LOG.warning("Editor settings links can only link targets on SystemFileSystem, ignoring link " + link.getPath());
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.WARNING, "Can't resolve editor settings link, ignoring link " + link.getPath(), ioe);
                        }
                    } else {
                        targetFile = FileUtil.getConfigFile((String)targetFilePath);
                    }
                }
            }
            if (targetFile != null) {
                FileObject baseFolder = this.threadsBaseFolder.get();
                if (!targetFile.isFolder() || targetFile == baseFolder || !FileUtil.isParentOf((FileObject)baseFolder, (FileObject)targetFile)) {
                    LOG.warning("Editor settings link '" + link.getPath() + "' is not pointing to a real subfolder of '" + baseFolder.getPath() + "', but to '" + targetFile.getPath() + "'. Ignoring the link.");
                    targetFile = null;
                }
            }
            return targetFile;
        }

        private void addLegacyFiles(FileObject mimeFolder, String profileId, String filePath, Map<String, List<Object[]>> files, boolean moduleFiles) {
            if (profileId == null) {
                String defaultProfileId;
                if (this.isUsingProfiles) {
                    FileObject[] profileHomes;
                    for (FileObject f : profileHomes = mimeFolder.getChildren()) {
                        if (!f.isFolder() || f.getNameExt().equals(MODULE_FILES_FOLDER)) continue;
                        String id = f.getNameExt();
                        FileObject legacyFile = f.getFileObject(filePath);
                        if (legacyFile == null) continue;
                        this.addFile(legacyFile, files, id, f, true);
                    }
                    defaultProfileId = DEFAULT_PROFILE_NAME;
                } else {
                    defaultProfileId = null;
                }
                FileObject legacyFile = mimeFolder.getFileObject(filePath);
                if (legacyFile != null) {
                    this.addFile(legacyFile, files, defaultProfileId, null, true);
                }
            } else if (profileId.equals(DEFAULT_PROFILE_NAME)) {
                FileObject file = mimeFolder.getFileObject(filePath);
                if (file != null) {
                    this.addFile(file, files, profileId, null, moduleFiles);
                }
            } else {
                FileObject file;
                FileObject profileHome = mimeFolder.getFileObject(profileId);
                if (profileHome != null && profileHome.isFolder() && (file = profileHome.getFileObject(filePath)) != null) {
                    this.addFile(file, files, profileId, profileHome, moduleFiles);
                }
            }
        }

        private void addFile(FileObject file, Map<String, List<Object[]>> files, String profileId, FileObject profileHome, boolean moduleFiles) {
            List<Object[]> pair = files.get(profileId);
            if (pair == null) {
                pair = new ArrayList<Object[]>();
                files.put(profileId, pair);
            }
            pair.add(new Object[]{profileHome, file, moduleFiles, null, true});
            if (LOG.isLoggable(Level.INFO)) {
                Utils.logOnce(LOG, Level.INFO, this.settingTypeId + " settings should reside in '" + this.settingTypeId + "' subfolder, see #90403 for details. Offending file '" + file.getPath() + "'", null);
            }
        }
    }

    static final class Cache
    implements LookupListener {
        private static Cache INSTANCE = null;
        private final Lookup.Result<StorageDescription> lookupResult;
        private final Map<String, StorageDescription> cache = new HashMap<String, StorageDescription>();

        public static synchronized Cache getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new Cache();
            }
            return INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StorageDescription find(String id) {
            Map<String, StorageDescription> map = this.cache;
            synchronized (map) {
                return this.cache.get(id);
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.rebuild();
        }

        private Cache() {
            this.lookupResult = Lookup.getDefault().lookupResult(StorageDescription.class);
            this.rebuild();
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rebuild() {
            Map<String, StorageDescription> map = this.cache;
            synchronized (map) {
                Collection allInstances = this.lookupResult.allInstances();
                HashSet<String> allIds = new HashSet<String>();
                for (StorageDescription sd : allInstances) {
                    allIds.add(sd.getId());
                }
                this.cache.keySet().retainAll(allIds);
                for (StorageDescription sd : allInstances) {
                    if (this.cache.containsKey(sd.getId())) continue;
                    this.cache.put(sd.getId(), sd);
                }
            }
        }
    }

    public static interface LocatorFactory {
        public Locator createLocator(StorageDescription var1);
    }

    public static interface Locator {
        public void scan(FileObject var1, String var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7, Map<String, List<Object[]>> var8);

        public String getWritableFileName(String var1, String var2, String var3, boolean var4);

        public boolean isUsingProfiles();
    }
}

