/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.project.api.ServiceDescriptor;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.WebServiceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class MavenWebService
implements WebServiceImplementation {
    public static final String CLIENT_PREFIX = "_C_";
    public static final String SERVICE_PREFIX = "_S_";
    private JaxWsService service;
    private Project prj;

    public MavenWebService(JaxWsService service, Project prj) {
        this.service = service;
        this.prj = prj;
    }

    public String getIdentifier() {
        if (this.service.isServiceProvider()) {
            return this.service.getImplementationClass();
        }
        return this.service.getId();
    }

    public boolean isServiceProvider() {
        return this.service.isServiceProvider();
    }

    public WebService.Type getServiceType() {
        return WebService.Type.SOAP;
    }

    public ServiceDescriptor getServiceDescriptor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Node createNode() {
        if (this.service.isServiceProvider()) {
            SourceGroup[] srcGroups = ProjectUtils.getSources((Project)this.prj).getSourceGroups("java");
            String implClass = this.service.getImplementationClass();
            for (SourceGroup srcGroup : srcGroups) {
                FileObject srcRoot = srcGroup.getRootFolder();
                FileObject implClassFo = this.getImplementationClass(implClass, srcRoot);
                if (implClassFo == null) continue;
                return new JaxWsNode(this.service, srcRoot, implClassFo);
            }
        } else {
            return new JaxWsClientNode(JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.prj.getProjectDirectory()), this.service);
        }
        return null;
    }

    private FileObject getImplementationClass(String implClass, FileObject srcRoot) {
        if (implClass != null && srcRoot != null) {
            return srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
        }
        return null;
    }
}

