/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ResourcesMappingModel
extends JsfPageModel {
    static final String STATIC_RESOURCES_KEY = "static_resources";
    private static final char RESOURCES_SEPARATOR = ';';
    private static final char NAME_SEPARATOR = '@';
    private static final char LIB_SEPARATOR = ':';
    private static final Pattern EL_STATEMENT_PATTERN = Pattern.compile("^[$#]+[{].*[}]");
    private static final Pattern JSF_RESOURCE_PATTERN = Pattern.compile(".*[#$][{].*(resource)[\\[].*[\\]].*[}]");
    private final FileObject file;
    private final List<Resource> staticResources;

    public ResourcesMappingModel(FileObject file, List<Resource> resources) {
        this.file = file;
        this.staticResources = resources;
    }

    @Override
    public String storeToIndex(IndexDocument document) {
        StringBuilder resString = new StringBuilder();
        Iterator<Resource> it = this.staticResources.iterator();
        while (it.hasNext()) {
            Resource resource = it.next();
            resString.append(resource.type.toString());
            resString.append('@');
            resString.append(resource.name);
            resString.append(':');
            resString.append(resource.library);
            if (!it.hasNext()) continue;
            resString.append(';');
        }
        document.addPair(STATIC_RESOURCES_KEY, resString.toString(), true, true);
        return "";
    }

    public static Collection<? extends Resource> parseResourcesFromString(String resString) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String resource : resString.split("[;]")) {
            int nameSepIndex = resource.indexOf(64);
            int libSepIndex = resource.indexOf(58);
            if (nameSepIndex == -1 || libSepIndex == -1) continue;
            resources.add(new Resource(ResourceType.fromString(resource.substring(0, nameSepIndex)), resource.substring(nameSepIndex + 1, libSepIndex), resource.substring(libSepIndex + 1)));
        }
        return resources;
    }

    private static String getAttributeELValue(Snapshot htmlSnapshot, String originalContent, Attribute attribute) {
        int startOffset = htmlSnapshot.getOriginalOffset(attribute.valueOffset());
        int endOffset = htmlSnapshot.getOriginalOffset(attribute.valueOffset() + attribute.value().length());
        if (startOffset == -1 || endOffset == -1 || startOffset > endOffset) {
            return null;
        }
        String quotedValue = originalContent.substring(startOffset, endOffset);
        if (quotedValue.startsWith("'") || quotedValue.startsWith("\"")) {
            return quotedValue.substring(1, quotedValue.length() - 1);
        }
        return quotedValue;
    }

    static boolean isELExpression(String statement) {
        return EL_STATEMENT_PATTERN.matcher(statement).matches();
    }

    static boolean isJsfResource(String elExpression) {
        return JSF_RESOURCE_PATTERN.matcher(elExpression).matches();
    }

    static Resource parseResource(ResourceType resourceType, String expression) {
        int resourceEndBracketOffset;
        int resourceStartBracketOffset = expression.indexOf("resource[");
        String resourceValue = expression.substring(resourceStartBracketOffset + 9, resourceEndBracketOffset = expression.indexOf("]", resourceStartBracketOffset));
        if (resourceValue.startsWith("'") || resourceValue.startsWith("\"")) {
            resourceValue = resourceValue.substring(1, resourceValue.length() - 1);
        }
        if (resourceValue.isEmpty()) {
            return null;
        }
        int colonOffset = resourceValue.indexOf(":");
        return new Resource(resourceType, colonOffset == -1 ? resourceValue : resourceValue.substring(colonOffset + 1), colonOffset == -1 ? "" : resourceValue.substring(0, colonOffset));
    }

    public static enum ResourceType {
        SCRIPT("script"),
        STYLESHEET("stylesheet");

        private final String value;

        private ResourceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static ResourceType fromString(String string) {
            for (ResourceType resourceType : ResourceType.values()) {
                if (!resourceType.value.equals(string)) continue;
                return resourceType;
            }
            return null;
        }
    }

    public static class Resource {
        private final ResourceType type;
        private final String name;
        private final String library;

        public Resource(ResourceType type, String name, String library) {
            this.type = type;
            this.name = name;
            this.library = library;
        }

        public ResourceType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getLibrary() {
            return this.library;
        }
    }

    public static class Factory
    extends JsfPageModelFactory {
        private static final String VIRTUAL_SOURCE = "@@@";
        private static final String OUTPUT_STYLESHEET_TAG_NAME = "outputStylesheet";
        private static final String OUTPUT_SCRIPT_TAG_NAME = "outputScript";
        private static final String LINK_TAG_NAME = "link";
        private static final String SCRIPT_TAG_NAME = "script";

        @Override
        public JsfPageModel getModel(HtmlParserResult result) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            FileObject file = result.getSnapshot().getSource().getFileObject();
            resources.addAll(this.getResourcesDefinedByJsfComponents(result));
            resources.addAll(this.getResourcesDefinedByHtmlTags(result));
            return new ResourcesMappingModel(file, resources);
        }

        @Override
        public JsfPageModel loadFromIndex(IndexResult result) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            String resString = result.getValue(ResourcesMappingModel.STATIC_RESOURCES_KEY);
            resources.addAll(ResourcesMappingModel.parseResourcesFromString(resString));
            return new ResourcesMappingModel(result.getFile(), resources);
        }

        private Collection<Resource> getResourcesDefinedByJsfComponents(HtmlParserResult result) {
            final ArrayList<Resource> resources = new ArrayList<Resource>();
            Node node = result.root(DefaultLibraryInfo.HTML.getNamespace());
            if (node == null || node.children().isEmpty()) {
                node = result.root(DefaultLibraryInfo.HTML.getLegacyNamespace());
            }
            if (node == null || node.children().isEmpty()) {
                return resources;
            }
            ElementUtils.visitChildren((Node)node, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: {
                            OpenTag openTag = (OpenTag)node;
                            if (!LexerUtils.equals((CharSequence)Factory.OUTPUT_STYLESHEET_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)false, (boolean)true) && !LexerUtils.equals((CharSequence)Factory.OUTPUT_SCRIPT_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)false, (boolean)true)) break;
                            Attribute name = openTag.getAttribute("name");
                            Attribute library = openTag.getAttribute("library");
                            if (name == null) break;
                            Resource resource = new Resource(LexerUtils.equals((CharSequence)Factory.OUTPUT_SCRIPT_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)false, (boolean)true) ? ResourceType.SCRIPT : ResourceType.STYLESHEET, name.unquotedValue().toString(), library == null ? "" : library.unquotedValue().toString());
                            resources.add(resource);
                            break;
                        }
                    }
                }
            });
            return resources;
        }

        private Collection<Resource> getResourcesDefinedByHtmlTags(final HtmlParserResult result) {
            final ArrayList<Resource> resources = new ArrayList<Resource>();
            Node node = result.root();
            if (node == null || node.children().isEmpty()) {
                return resources;
            }
            final String[] originalContent = new String[1];
            try {
                ParserManager.parse(Arrays.asList(result.getSnapshot().getSource()), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        originalContent[0] = resultIterator.getSnapshot().getText().toString();
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ElementUtils.visitChildren((Node)node, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: {
                            Resource resource;
                            String elResource;
                            OpenTag openTag = (OpenTag)node;
                            if (LexerUtils.equals((CharSequence)Factory.LINK_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)true, (boolean)true)) {
                                Resource resource2;
                                String elResource2;
                                Attribute rel = openTag.getAttribute("rel");
                                Attribute type = openTag.getAttribute("type");
                                Attribute href = openTag.getAttribute("href");
                                if (rel == null || type == null || href == null || !CharSequenceUtilities.equals((CharSequence)href.unquotedValue(), (Object)Factory.VIRTUAL_SOURCE) || (elResource2 = ResourcesMappingModel.getAttributeELValue(result.getSnapshot(), originalContent[0], href)) == null || !ResourcesMappingModel.isELExpression(elResource2) || !ResourcesMappingModel.isJsfResource(elResource2) || (resource2 = ResourcesMappingModel.parseResource(ResourceType.STYLESHEET, elResource2)) == null) break;
                                resources.add(resource2);
                                break;
                            }
                            if (!LexerUtils.equals((CharSequence)Factory.SCRIPT_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)true, (boolean)true)) break;
                            Attribute type = openTag.getAttribute("type");
                            Attribute src = openTag.getAttribute("src");
                            if (type == null || src == null || !CharSequenceUtilities.equals((CharSequence)src.unquotedValue(), (Object)Factory.VIRTUAL_SOURCE) || (elResource = ResourcesMappingModel.getAttributeELValue(result.getSnapshot(), originalContent[0], src)) == null || !ResourcesMappingModel.isELExpression(elResource) || !ResourcesMappingModel.isJsfResource(elResource) || (resource = ResourcesMappingModel.parseResource(ResourceType.SCRIPT, elResource)) == null) break;
                            resources.add(resource);
                            break;
                        }
                    }
                }
            });
            return resources;
        }
    }
}

