/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.ManagedProperty;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;
import org.netbeans.modules.web.jsf.editor.el.JsfVariablesModel;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class JsfELVariableResolver
implements ELVariableResolver {
    private static final String CONTENT_NAME = "JsfBeans";
    private static final String OBJECT_NAME__CC = "cc";
    private static final String ATTR_NAME__ATTRS = "attrs";
    private static final String ATTR_NAME__ID = "id";
    private static final String ATTR_NAME__RENDERED = "rendered";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__ATTRS = ELVariableResolver.VariableInfo.createResolvedVariable((String)"attrs", (String)Object.class.getName());
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__ID = ELVariableResolver.VariableInfo.createResolvedVariable((String)"id", (String)Object.class.getName());
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__RENDERED = ELVariableResolver.VariableInfo.createResolvedVariable((String)"rendered", (String)Object.class.getName());

    public ELVariableResolver.FieldInfo getInjectableField(String beanName, FileObject target, ResolverContext context) {
        for (FacesManagedBean bean : this.getJsfManagedBeans(target, context)) {
            if (!beanName.equals(bean.getManagedBeanName())) continue;
            return new ELVariableResolver.FieldInfo(bean.getManagedBeanClass());
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject target, ResolverContext context) {
        for (FacesManagedBean bean : this.getJsfManagedBeans(target, context)) {
            if (!clazz.equals(bean.getManagedBeanClass())) continue;
            return bean.getManagedBeanName();
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject target, ResolverContext context) {
        List<FacesManagedBean> beans = this.getJsfManagedBeans(target, context);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(beans.size());
        for (FacesManagedBean bean : beans) {
            if (bean.getManagedBeanClass() == null || bean.getManagedBeanName() == null) continue;
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bean.getManagedBeanName(), (String)bean.getManagedBeanClass()));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset, ResolverContext context) {
        List<JsfVariableContext> allJsfVariables = this.getAllJsfVariables(snapshot, offset);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(allJsfVariables.size());
        for (JsfVariableContext jsfVariable : allJsfVariables) {
            String expression = jsfVariable.getResolvedExpression();
            if (expression == null) continue;
            result.add(ELVariableResolver.VariableInfo.createUnresolvedVariable((String)jsfVariable.getVariableName(), (String)expression));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String objectName, Snapshot snapshot, ResolverContext context) {
        ArrayList<ELVariableResolver.VariableInfo> variables = new ArrayList<ELVariableResolver.VariableInfo>(3);
        if (OBJECT_NAME__CC.equals(objectName)) {
            variables.add(VARIABLE_INFO__ID);
            variables.add(VARIABLE_INFO__RENDERED);
            variables.add(VARIABLE_INFO__ATTRS);
            JsfELVariableResolver.proposeFromComponentType(snapshot, context, variables);
        } else if (ATTR_NAME__ATTRS.equals(objectName)) {
            variables.add(VARIABLE_INFO__ID);
            variables.add(VARIABLE_INFO__RENDERED);
            final JsfPageModelFactory modelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
            assert (modelFactory != null);
            final AtomicReference ccModelRef = new AtomicReference();
            try {
                ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                        if (parseResult instanceof HtmlParserResult) {
                            ccModelRef.set((CompositeComponentModel)modelFactory.getModel((HtmlParserResult)parseResult));
                        }
                    }
                });
                CompositeComponentModel ccmodel = (CompositeComponentModel)ccModelRef.get();
                if (ccmodel != null) {
                    Collection<Map<String, String>> allCCInterfaceAttrs = ccmodel.getExistingInterfaceAttributes();
                    for (Map<String, String> attrsMap : allCCInterfaceAttrs) {
                        String name = attrsMap.get(ATTR_NAME);
                        if (name == null) continue;
                        String clazz = attrsMap.get(ATTR_TYPE) == null ? Object.class.getName() : attrsMap.get(ATTR_TYPE);
                        variables.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)name, (String)clazz));
                    }
                }
            }
            catch (ParseException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return variables;
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot snapshot, ResolverContext context) {
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
        for (FacesManagedBean bean : this.getJsfManagedBeans(snapshot.getSource().getFileObject(), context)) {
            if (bean.getManagedBeanClass() == null || bean.getManagedBeanName() != null || !scope.equals(bean.getManagedBeanScopeString())) continue;
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bean.getManagedBeanName(), (String)bean.getManagedBeanClass()));
        }
        return result;
    }

    private List<FacesManagedBean> getJsfManagedBeans(FileObject target, ResolverContext context) {
        ArrayList<FacesManagedBean> result = new ArrayList<FacesManagedBean>();
        Project project = FileOwnerQuery.getOwner((FileObject)target);
        if (project == null) {
            return result;
        }
        if (context.getContent(CONTENT_NAME) == null) {
            context.setContent(CONTENT_NAME, (Object)JSFBeanCache.getBeans((Project)project));
        }
        List beans = (List)context.getContent(CONTENT_NAME);
        result.addAll(beans);
        result.addAll(JsfELVariableResolver.getFaceletParameters(target, beans));
        return result;
    }

    private List<JsfVariableContext> getAllJsfVariables(Snapshot snapshot, final int offset) {
        final ArrayList<JsfVariableContext> result = new ArrayList<JsfVariableContext>();
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (parseResult instanceof HtmlParserResult) {
                        JsfVariablesModel model = JsfVariablesModel.getModel((HtmlParserResult)parseResult, resultIterator.getSnapshot());
                        List<JsfVariableContext> contexts = model.getAllAvailableVariables(offset, false);
                        result.addAll(contexts);
                    }
                }
            });
        }
        catch (ParseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return result;
    }

    private static Collection<? extends FacesManagedBean> getFaceletParameters(FileObject target, final List<FacesManagedBean> managedBeans) {
        final ArrayList<FacesManagedBean> result = new ArrayList<FacesManagedBean>(managedBeans);
        try {
            ParserManager.parse(Arrays.asList(Source.create((FileObject)target)), (UserTask)new UserTask(){

                public void run(final ResultIterator resultIterator) throws Exception {
                    for (Embedding e : resultIterator.getEmbeddings()) {
                        HtmlParserResult parserResult;
                        if (!e.getMimeType().equals("text/html") || (parserResult = (HtmlParserResult)resultIterator.getResultIterator(e).getParserResult()) == null) continue;
                        Node root = parserResult.root(DefaultLibraryInfo.FACELETS.getNamespace());
                        if (root == null || root.children().isEmpty()) {
                            root = parserResult.root(DefaultLibraryInfo.FACELETS.getLegacyNamespace());
                        }
                        ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){

                            public void visit(Element node) {
                                OpenTag ot = (OpenTag)node;
                                if (LexerUtils.equals((CharSequence)"param", (CharSequence)ot.unqualifiedName(), (boolean)true, (boolean)true)) {
                                    Attribute nameAttr = ot.getAttribute(JsfELVariableResolver.ATTR_NAME);
                                    Attribute valueAttr = ot.getAttribute("value");
                                    if (nameAttr != null && valueAttr != null) {
                                        int doc_from = parserResult.getSnapshot().getOriginalOffset(valueAttr.valueOffset());
                                        int doc_to = parserResult.getSnapshot().getOriginalOffset(valueAttr.valueOffset() + valueAttr.value().length());
                                        if (doc_from == -1 || doc_to == -1 || doc_from > doc_to) {
                                            return;
                                        }
                                        CharSequence topLevelSnapshotText = resultIterator.getSnapshot().getText();
                                        String documentValueContent = topLevelSnapshotText.subSequence(doc_from, doc_to).toString();
                                        for (FacesManagedBean managedBean : managedBeans) {
                                            if (!documentValueContent.contains(managedBean.getManagedBeanName())) continue;
                                            result.add(new ParamDefinedManagedBean(managedBean, (String)nameAttr.unquotedValue()));
                                        }
                                    }
                                }
                            }
                        }, (ElementType)ElementType.OPEN_TAG);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private static void proposeFromComponentType(final Snapshot snapshot, ResolverContext context, final List<ELVariableResolver.VariableInfo> variables) {
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (parseResult instanceof HtmlParserResult) {
                        HtmlParserResult result = (HtmlParserResult)parseResult;
                        Node root = result.root(DefaultLibraryInfo.COMPOSITE.getNamespace());
                        if (root.children().isEmpty()) {
                            root = result.root(DefaultLibraryInfo.COMPOSITE.getLegacyNamespace());
                        }
                        Collection children = root.children(ElementType.OPEN_TAG);
                        for (Element child : children) {
                            JavaSource js;
                            Attribute attribute;
                            OpenTag ot = (OpenTag)child;
                            if (!"interface".equals(ot.unqualifiedName()) || (attribute = ot.getAttribute("componentType")) == null || (js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)snapshot.getSource().getFileObject()), (FileObject[])new FileObject[0])) == null) continue;
                            js.runUserActionTask((Task)new Task<CompilationController>(){

                                public void run(CompilationController parameter) throws Exception {
                                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                                    TypeElement element = parameter.getElements().getTypeElement(attribute.unquotedValue());
                                    if (element != null) {
                                        JsfELVariableResolver.proposeJavaMethodsForElements(parameter, element, variables);
                                    }
                                }
                            }, true);
                        }
                    }
                }
            });
        }
        catch (ParseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static void proposeJavaMethodsForElements(CompilationController info, javax.lang.model.element.Element element, List<ELVariableResolver.VariableInfo> variables) {
        for (ExecutableElement enclosed : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (element.getSimpleName().contentEquals("Object") || !enclosed.getModifiers().contains((Object)Modifier.PUBLIC) || enclosed.getModifiers().contains((Object)Modifier.STATIC)) continue;
            boolean hasParameters = !enclosed.getParameters().isEmpty();
            String methodName = enclosed.getSimpleName().toString();
            String propertyName = JsfELVariableResolver.getPropertyName(methodName, enclosed.getReturnType(), true);
            if (hasParameters) {
                propertyName = methodName;
            }
            variables.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)propertyName, (String)enclosed.getReturnType().toString()));
        }
    }

    public static String getPropertyName(String accessor, TypeMirror returnType, boolean includeSetter) {
        Parameters.notEmpty((CharSequence)"accessor", (CharSequence)accessor);
        int prefixLength = JsfELVariableResolver.getPrefixLength(accessor, includeSetter);
        String withoutPrefix = accessor.substring(prefixLength);
        if (withoutPrefix.isEmpty()) {
            return accessor;
        }
        char firstChar = withoutPrefix.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return accessor;
        }
        if (returnType != null && accessor.startsWith("is") && returnType.getKind() != TypeKind.BOOLEAN) {
            return accessor;
        }
        if (withoutPrefix.length() > 1 && Character.isUpperCase(withoutPrefix.charAt(1))) {
            return withoutPrefix;
        }
        return Character.toLowerCase(firstChar) + withoutPrefix.substring(1);
    }

    private static int getPrefixLength(String accessor, boolean includeSetter) {
        ArrayList<String> accessorPrefixes = new ArrayList<String>();
        accessorPrefixes.add("get");
        if (includeSetter) {
            accessorPrefixes.add("set");
        }
        accessorPrefixes.add("is");
        for (String prefix : accessorPrefixes) {
            if (!accessor.startsWith(prefix)) continue;
            return prefix.length();
        }
        return 0;
    }

    private static class ParamDefinedManagedBean
    implements FacesManagedBean {
        private final FacesManagedBean managedBean;
        private final String name;

        public ParamDefinedManagedBean(FacesManagedBean managedBean, String name) {
            this.managedBean = managedBean;
            this.name = name;
        }

        public Boolean getEager() {
            return this.managedBean.getEager();
        }

        public String getManagedBeanName() {
            return this.name;
        }

        public String getManagedBeanClass() {
            return this.managedBean.getManagedBeanClass();
        }

        public ManagedBean.Scope getManagedBeanScope() {
            return this.managedBean.getManagedBeanScope();
        }

        public String getManagedBeanScopeString() {
            return this.managedBean.getManagedBeanScopeString();
        }

        public List<ManagedProperty> getManagedProperties() {
            return this.managedBean.getManagedProperties();
        }
    }
}

