/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.ClassItem;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.elements.DescriptionFilter;
import org.netbeans.modules.refactoring.java.ui.elements.ElementNode;
import org.netbeans.modules.refactoring.java.ui.elements.FiltersDescription;
import org.netbeans.modules.refactoring.java.ui.elements.FiltersManager;
import org.netbeans.modules.refactoring.java.ui.elements.JCheckBoxIcon;
import org.netbeans.modules.refactoring.java.ui.elements.SortActionSupport;
import org.netbeans.modules.refactoring.java.ui.elements.TapPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class MoveMembersPanel
extends JPanel
implements CustomRefactoringPanel,
ExplorerManager.Provider,
DescriptionFilter,
FiltersManager.FilterChangeListener {
    private static final String JAVADOC = "updateJavadoc.moveMembers";
    private static final String DELEGATE = "delegate.moveMembers";
    private static final String DEPRECATE = "deprecate.moveMembers";
    private static final RequestProcessor RP = new RequestProcessor(MoveMembersPanel.class.getName(), 1);
    private final ListCellRenderer GROUP_CELL_RENDERER = new MoveClassPanel.GroupCellRenderer();
    private final ListCellRenderer PROJECT_CELL_RENDERER = new MoveClassPanel.ProjectCellRenderer();
    private final ListCellRenderer CLASS_CELL_RENDERER = new MoveClassPanel.ClassListCellRenderer();
    private ChangeListener parent;
    private FiltersManager filtersManager;
    private final ExplorerManager manager = new ExplorerManager();
    private final TreePathHandle[] selectedElements;
    private final FileObject fileObject;
    private TapPanel filtersPanel;
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INHERITED = "show_inherited";
    private JToggleButton sortByNameButton;
    private JToggleButton sortByPositionButton;
    private boolean naturalSort;
    private final Action[] actions;
    private Project project;
    private SourceGroup[] groups;
    private JLabel label;
    private ComponentListener componenListener;
    private boolean initialized = false;
    private JRadioButton btnAsIs;
    private JRadioButton btnDefault;
    private JRadioButton btnEscalate;
    private JRadioButton btnJavadocAsIs;
    private JRadioButton btnJavadocUpdate;
    private JRadioButton btnPrivate;
    private JRadioButton btnProtected;
    private JRadioButton btnPublic;
    private JCheckBox chkDelegate;
    private JCheckBox chkDeprecate;
    private JComboBox classComboBox;
    private ButtonGroup javadocButtonGroup;
    private JPanel javadocPanel;
    private JLabel labelClass;
    private JLabel labelLocation;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JLabel lblMoveMembersFrom;
    private JLabel lblSource;
    private JPanel membersListPanel;
    private OutlineView outlineView1;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;
    private JPanel targetPanel;
    private ButtonGroup visibilityButtonGroup;
    private JPanel visibilityPanel;

    public MoveMembersPanel(TreePathHandle[] selectedElements, final ChangeListener parent) {
        this.parent = parent;
        this.naturalSort = NbPreferences.forModule(MoveMembersPanel.class).getBoolean("naturalSort", false);
        this.selectedElements = selectedElements;
        this.fileObject = selectedElements[0].getFileObject();
        this.initComponents();
        this.rootComboBox.setRenderer(this.GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.projectsComboBox.setRenderer(this.PROJECT_CELL_RENDERER);
        this.classComboBox.setRenderer(this.CLASS_CELL_RENDERER);
        Project fileOwner = this.fileObject != null ? FileOwnerQuery.getOwner((FileObject)this.fileObject) : null;
        this.project = fileOwner != null ? fileOwner : OpenProjects.getDefault().getOpenProjects()[0];
        this.manager.setRootContext(ElementNode.getWaitNode());
        this.outlineView1.getOutline().setRootVisible(true);
        this.outlineView1.getOutline().setTableHeader(null);
        this.initFiltersPanel();
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this), new SortActionSupport.SortBySourceAction(this)};
        ItemListener parentListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                parent.stateChanged(null);
            }
        };
        this.btnAsIs.addItemListener(parentListener);
        this.btnDefault.addItemListener(parentListener);
        this.btnEscalate.addItemListener(parentListener);
        this.btnJavadocAsIs.addItemListener(parentListener);
        this.btnJavadocUpdate.addItemListener(parentListener);
        this.btnPrivate.addItemListener(parentListener);
        this.btnProtected.addItemListener(parentListener);
        this.btnPublic.addItemListener(parentListener);
    }

    public Action[] getActions() {
        return this.actions;
    }

    private void initFiltersPanel() throws MissingResourceException {
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        FiltersDescription desc = new FiltersDescription();
        desc.addFilter(SHOW_FIELDS, NbBundle.getMessage(MoveMembersPanel.class, (String)"LBL_ShowFields"), NbBundle.getMessage(MoveMembersPanel.class, (String)"LBL_ShowFieldsTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/filterHideFields.png", (boolean)false), null);
        desc.addFilter(SHOW_STATIC, NbBundle.getMessage(MoveMembersPanel.class, (String)"LBL_ShowStatic"), NbBundle.getMessage(MoveMembersPanel.class, (String)"LBL_ShowStaticTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/filterHideStatic.png", (boolean)false), null);
        desc.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage(MoveMembersPanel.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage(MoveMembersPanel.class, (String)"LBL_ShowNonPublicTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/filterHideNonPublic.png", (boolean)false), null);
        AbstractButton[] res = new AbstractButton[4];
        this.sortByNameButton = new JToggleButton(new SortActionSupport.SortByNameAction(this));
        this.sortByNameButton.setToolTipText(this.sortByNameButton.getText());
        this.sortByNameButton.setText(null);
        this.sortByNameButton.setSelected(!this.isNaturalSort());
        res[0] = this.sortByNameButton;
        this.sortByPositionButton = new JToggleButton(new SortActionSupport.SortBySourceAction(this));
        this.sortByPositionButton.setToolTipText(this.sortByPositionButton.getText());
        this.sortByPositionButton.setText(null);
        this.sortByPositionButton.setSelected(this.isNaturalSort());
        res[1] = this.sortByPositionButton;
        res[2] = new JButton(null, new JCheckBoxIcon(true, new Dimension(16, 16)));
        res[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveMembersPanel.this.selectAll(true);
            }
        });
        res[2].setToolTipText(NbBundle.getMessage(MoveMembersPanel.class, (String)"TIP_SelectAll"));
        res[3] = new JButton(null, new JCheckBoxIcon(false, new Dimension(16, 16)));
        res[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveMembersPanel.this.selectAll(false);
            }
        });
        res[3].setToolTipText(NbBundle.getMessage(MoveMembersPanel.class, (String)"TIP_DeselectAll"));
        this.filtersManager = FiltersDescription.createManager(desc);
        this.filtersManager.hookChangeListener(this);
        JComponent buttons = this.filtersManager.getComponent(res);
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.membersListPanel.add((Component)this.filtersPanel, "South");
    }

    private void initValues() {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(openProjects, new MoveClassPanel.ProjectByDisplayNameComparator());
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(openProjects);
        this.projectsComboBox.setModel(projectsModel);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoots();
        this.updatePackages();
        this.updateClasses();
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.groups = sources.getSourceGroups("java");
        int preselectedItem = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.fileObject == null) continue;
            try {
                if (!this.groups[i].contains(this.fileObject)) continue;
                preselectedItem = i;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        if (this.groups.length > 0) {
            this.rootComboBox.setSelectedIndex(preselectedItem);
        }
    }

    private void updatePackages() {
        SourceGroup g = (SourceGroup)this.rootComboBox.getSelectedItem();
        this.packageComboBox.setModel(g != null ? PackageView.createListView((SourceGroup)g) : new DefaultComboBoxModel());
    }

    private void updateClasses() {
        this.classComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{ElementNode.getWaitNode()}));
        RP.post(new Runnable(){

            @Override
            public void run() {
                DefaultComboBoxModel<Object> model;
                SourceGroup g = (SourceGroup)MoveMembersPanel.this.rootComboBox.getSelectedItem();
                String packageName = MoveMembersPanel.this.packageComboBox.getSelectedItem().toString();
                if (g != null && packageName != null) {
                    String pathname = packageName.replace(".", "/");
                    FileObject fo = g.getRootFolder().getFileObject(pathname);
                    ClassPath bootCp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
                    ClassPath compileCp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
                    ClassPath sourcePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                    ClasspathInfo info = ClasspathInfo.create((ClassPath)bootCp, (ClassPath)compileCp, (ClassPath)sourcePath);
                    HashSet<1> searchScopeType = new HashSet<1>(1);
                    final Set<String> packageSet = Collections.singleton(packageName);
                    searchScopeType.add(new ClassIndex.SearchScopeType(){

                        public Set<? extends String> getPackages() {
                            return packageSet;
                        }

                        public boolean isSources() {
                            return true;
                        }

                        public boolean isDependencies() {
                            return false;
                        }
                    });
                    final Set result = info.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, searchScopeType);
                    if (result != null && !result.isEmpty()) {
                        JavaSource javaSource = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
                        final ArrayList items = new ArrayList(result.size());
                        try {
                            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                                private AtomicBoolean cancel = new AtomicBoolean();

                                public void cancel() {
                                    this.cancel.set(true);
                                }

                                public void run(CompilationController parameter) throws Exception {
                                    for (ElementHandle elementHandle : result) {
                                        String fqn;
                                        TypeElement element = (TypeElement)elementHandle.resolve((CompilationInfo)parameter);
                                        if (element == null || (fqn = element.getQualifiedName().toString()).isEmpty()) continue;
                                        Icon icon = ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers());
                                        int packageNameLength = ((String)packageSet.iterator().next()).length();
                                        String className = packageNameLength > 0 && packageNameLength < fqn.length() ? fqn.substring(packageNameLength + 1) : fqn;
                                        ClassItem classItem = new ClassItem(className, icon, TreePathHandle.create((Element)element, (CompilationInfo)parameter));
                                        items.add(classItem);
                                    }
                                }
                            }, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        Collections.sort(items, new Comparator(){
                            private Comparator COLLATOR = Collator.getInstance();

                            public int compare(Object o1, Object o2) {
                                if (!(o1 instanceof ClassItem)) {
                                    return 1;
                                }
                                if (!(o2 instanceof ClassItem)) {
                                    return -1;
                                }
                                ClassItem p1 = (ClassItem)o1;
                                ClassItem p2 = (ClassItem)o2;
                                return this.COLLATOR.compare(p1.getDisplayName(), p2.getDisplayName());
                            }
                        });
                        model = new DefaultComboBoxModel<ClassItem>(items.toArray(new ClassItem[items.size()]));
                    } else {
                        model = new DefaultComboBoxModel();
                    }
                } else {
                    model = new DefaultComboBoxModel();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MoveMembersPanel.this.classComboBox.setModel(model);
                        MoveMembersPanel.this.parent.stateChanged(null);
                    }
                });
            }
        });
    }

    @Override
    public Collection<ElementNode.Description> filter(Collection<ElementNode.Description> original) {
        JLayeredPane layeredPaneAbove;
        boolean non_public = this.filtersManager.isSelected(SHOW_NON_PUBLIC);
        boolean statik = this.filtersManager.isSelected(SHOW_STATIC);
        boolean fields = this.filtersManager.isSelected(SHOW_FIELDS);
        boolean inherited = false;
        boolean warn = false;
        ArrayList<ElementNode.Description> result = new ArrayList<ElementNode.Description>(original.size());
        for (ElementNode.Description description : original) {
            if (description.isConstructor()) {
                if (description.getSelected() != Boolean.TRUE) continue;
                warn |= true;
                continue;
            }
            if (!inherited && description.isInherited()) {
                if (description.getSelected() != Boolean.TRUE) continue;
                warn |= true;
                continue;
            }
            if (!non_public && !description.getModifiers().contains((Object)Modifier.PUBLIC)) {
                if (description.getSelected() != Boolean.TRUE) continue;
                warn |= true;
                continue;
            }
            if (!statik && description.getModifiers().contains((Object)Modifier.STATIC)) {
                if (description.getSelected() != Boolean.TRUE) continue;
                warn |= true;
                continue;
            }
            if (!fields && description.getKind() == ElementKind.FIELD) {
                if (description.getSelected() != Boolean.TRUE) continue;
                warn |= true;
                continue;
            }
            result.add(description);
        }
        Collections.sort(result, this.isNaturalSort() ? ElementNode.Description.POSITION_COMPARATOR : ElementNode.Description.ALPHA_COMPARATOR);
        if (warn) {
            if (this.label == null && this.outlineView1.isValid()) {
                layeredPaneAbove = JLayeredPane.getLayeredPaneAbove((Component)this.outlineView1);
                ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/warning_16.png", (boolean)false);
                this.label = new JLabel("Some selected members are not visible", imageIcon, 2);
                this.label.setBackground(this.outlineView1.getBackground());
                this.label.setOpaque(true);
                Rectangle ownerCompBounds = SwingUtilities.convertRectangle(this.outlineView1.getParent(), this.outlineView1.getBounds(), layeredPaneAbove);
                final Dimension labelSize = this.label.getPreferredSize();
                final Insets insets = this.outlineView1.getInsets();
                int x = ownerCompBounds.x + ownerCompBounds.width - labelSize.width - insets.right;
                int y = ownerCompBounds.y + ownerCompBounds.height - labelSize.height - insets.bottom;
                this.label.setBounds(x, y, labelSize.width, labelSize.height);
                this.componenListener = new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        Rectangle ownerCompBounds = SwingUtilities.convertRectangle(MoveMembersPanel.this.outlineView1.getParent(), MoveMembersPanel.this.outlineView1.getBounds(), layeredPaneAbove);
                        int x = ownerCompBounds.x + ownerCompBounds.width - labelSize.width - insets.right;
                        int y = ownerCompBounds.y + ownerCompBounds.height - labelSize.height - insets.bottom;
                        MoveMembersPanel.this.label.setBounds(x, y, labelSize.width, labelSize.height);
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        Rectangle ownerCompBounds = SwingUtilities.convertRectangle(MoveMembersPanel.this.outlineView1.getParent(), MoveMembersPanel.this.outlineView1.getBounds(), layeredPaneAbove);
                        int x = ownerCompBounds.x + ownerCompBounds.width - labelSize.width - insets.right;
                        int y = ownerCompBounds.y + ownerCompBounds.height - labelSize.height - insets.bottom;
                        MoveMembersPanel.this.label.setBounds(x, y, labelSize.width, labelSize.height);
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                };
                this.outlineView1.addComponentListener(this.componenListener);
                layeredPaneAbove.add((Component)this.label, JLayeredPane.POPUP_LAYER - 1);
            }
        } else {
            layeredPaneAbove = JLayeredPane.getLayeredPaneAbove((Component)this.outlineView1);
            if (this.label != null) {
                this.outlineView1.removeComponentListener(this.componenListener);
                this.componenListener = null;
                layeredPaneAbove.remove(this.label);
                this.label = null;
                layeredPaneAbove.repaint();
            }
        }
        return result;
    }

    @Override
    public void setNaturalSort(boolean naturalSort) {
        this.naturalSort = naturalSort;
        NbPreferences.forModule(MoveMembersPanel.class).putBoolean("naturalSort", naturalSort);
        if (null != this.sortByNameButton) {
            this.sortByNameButton.setSelected(!naturalSort);
        }
        if (null != this.sortByPositionButton) {
            this.sortByPositionButton.setSelected(naturalSort);
        }
        this.sort();
    }

    public void sort() {
        ElementNode root = this.getRootNode();
        if (null != root) {
            root.refreshRecursively();
        }
    }

    private ElementNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof ElementNode) {
            return (ElementNode)n;
        }
        return null;
    }

    private void selectAll(boolean select) {
        for (Node node : this.manager.getRootContext().getChildren().getNodes()) {
            ElementNode elementNode;
            CheckableNode check;
            if (!(node instanceof ElementNode) || (check = (CheckableNode)(elementNode = (ElementNode)node).getLookup().lookup(CheckableNode.class)) == null) continue;
            check.setSelected(Boolean.valueOf(select));
            elementNode.selectionChanged();
        }
    }

    public void initialize() {
        if (!this.initialized) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)MoveMembersPanel.this.fileObject);
                    if (javaSource != null) {
                        try {
                            javaSource.runUserActionTask((Task)new ElementScanningTask(), true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    MoveMembersPanel.this.initValues();
                }
            });
            this.initialized = true;
            this.parent.stateChanged(null);
        }
    }

    public Component getComponent() {
        return this;
    }

    private void initComponents() {
        this.visibilityButtonGroup = new ButtonGroup();
        this.javadocButtonGroup = new ButtonGroup();
        this.membersListPanel = new JPanel();
        this.outlineView1 = new OutlineView();
        this.visibilityPanel = new JPanel();
        this.btnEscalate = new JRadioButton();
        this.btnAsIs = new JRadioButton();
        this.btnPrivate = new JRadioButton();
        this.btnDefault = new JRadioButton();
        this.btnProtected = new JRadioButton();
        this.btnPublic = new JRadioButton();
        this.lblMoveMembersFrom = new JLabel();
        this.lblSource = new JLabel();
        this.chkDelegate = new JCheckBox();
        this.chkDeprecate = new JCheckBox();
        this.targetPanel = new JPanel();
        this.rootComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.labelProject = new JLabel();
        this.packageComboBox = new JComboBox();
        this.classComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelClass = new JLabel();
        this.javadocPanel = new JPanel();
        this.btnJavadocUpdate = new JRadioButton();
        this.btnJavadocAsIs = new JRadioButton();
        this.membersListPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.membersListPanel.border.title")));
        this.membersListPanel.setLayout(new BorderLayout());
        this.outlineView1.setDoubleBuffered(true);
        this.outlineView1.setDragSource(false);
        this.outlineView1.setDropTarget(false);
        this.outlineView1.setTreeSortable(true);
        this.membersListPanel.add((Component)this.outlineView1, "Center");
        this.visibilityPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.visibilityPanel.border.title")));
        this.visibilityButtonGroup.add(this.btnEscalate);
        this.btnEscalate.setSelected(true);
        this.btnEscalate.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnEscalate.text"));
        this.btnEscalate.setActionCommand(JavaMoveMembersProperties.Visibility.ESCALATE.name());
        this.visibilityButtonGroup.add(this.btnAsIs);
        this.btnAsIs.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnAsIs.text"));
        this.btnAsIs.setActionCommand(JavaMoveMembersProperties.Visibility.ASIS.name());
        this.visibilityButtonGroup.add(this.btnPrivate);
        this.btnPrivate.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnPrivate.text"));
        this.btnPrivate.setActionCommand(JavaMoveMembersProperties.Visibility.PRIVATE.name());
        this.visibilityButtonGroup.add(this.btnDefault);
        this.btnDefault.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnDefault.text"));
        this.btnDefault.setActionCommand(JavaMoveMembersProperties.Visibility.DEFAULT.name());
        this.visibilityButtonGroup.add(this.btnProtected);
        this.btnProtected.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnProtected.text"));
        this.btnProtected.setActionCommand(JavaMoveMembersProperties.Visibility.PROTECTED.name());
        this.visibilityButtonGroup.add(this.btnPublic);
        this.btnPublic.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnPublic.text"));
        this.btnPublic.setActionCommand(JavaMoveMembersProperties.Visibility.PUBLIC.name());
        GroupLayout visibilityPanelLayout = new GroupLayout(this.visibilityPanel);
        this.visibilityPanel.setLayout(visibilityPanelLayout);
        visibilityPanelLayout.setHorizontalGroup(visibilityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(visibilityPanelLayout.createSequentialGroup().addGroup(visibilityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnEscalate).addComponent(this.btnAsIs).addComponent(this.btnPrivate).addComponent(this.btnDefault).addComponent(this.btnProtected).addComponent(this.btnPublic)).addGap(0, 0, Short.MAX_VALUE)));
        visibilityPanelLayout.setVerticalGroup(visibilityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(visibilityPanelLayout.createSequentialGroup().addComponent(this.btnEscalate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAsIs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPrivate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPublic)));
        this.lblMoveMembersFrom.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.lblMoveMembersFrom.text"));
        this.lblSource.setText("<ClassName>");
        this.chkDelegate.setSelected(RefactoringModule.getOption(DELEGATE, Boolean.FALSE));
        this.chkDelegate.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.chkDelegate.text"));
        this.chkDelegate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveMembersPanel.this.chkDelegateItemStateChanged(evt);
            }
        });
        this.chkDeprecate.setSelected(RefactoringModule.getOption(DEPRECATE, Boolean.TRUE));
        this.chkDeprecate.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.chkDeprecate.text"));
        this.chkDeprecate.setEnabled(RefactoringModule.getOption(DELEGATE, Boolean.FALSE));
        this.chkDeprecate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveMembersPanel.this.chkDeprecateItemStateChanged(evt);
            }
        });
        this.targetPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.targetPanel.border.title")));
        this.rootComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveMembersPanel.this.rootComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.labelLocation.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.labelProject.text"));
        this.packageComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveMembersPanel.this.packageComboBoxItemStateChanged(evt);
            }
        });
        this.classComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveMembersPanel.this.classComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.labelPackage.text"));
        this.projectsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveMembersPanel.this.projectsComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.labelClass, (String)NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.labelClass.text"));
        GroupLayout targetPanelLayout = new GroupLayout(this.targetPanel);
        this.targetPanel.setLayout(targetPanelLayout);
        targetPanelLayout.setHorizontalGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addContainerGap().addGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addComponent(this.labelClass, -2, 86, -2).addGap(7, 7, 7).addComponent(this.classComboBox, 0, -1, Short.MAX_VALUE)).addGroup(targetPanelLayout.createSequentialGroup().addComponent(this.labelPackage, -2, 86, -2).addGap(7, 7, 7).addComponent(this.packageComboBox, 0, -1, Short.MAX_VALUE)).addGroup(targetPanelLayout.createSequentialGroup().addComponent(this.labelProject, -2, 55, -2).addGap(38, 38, 38).addComponent(this.projectsComboBox, 0, -1, Short.MAX_VALUE)).addGroup(targetPanelLayout.createSequentialGroup().addComponent(this.labelLocation, -2, 66, -2).addGap(27, 27, 27).addComponent(this.rootComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        targetPanelLayout.setVerticalGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelProject)).addComponent(this.projectsComboBox, -2, -1, -2)).addGap(6, 6, 6).addGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelLocation)).addComponent(this.rootComboBox, -2, -1, -2)).addGap(6, 6, 6).addGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelPackage)).addComponent(this.packageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(targetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.labelClass)).addComponent(this.classComboBox, -2, -1, -2)).addGap(0, 8, Short.MAX_VALUE)));
        this.javadocPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.javadocPanel.border.title")));
        this.javadocButtonGroup.add(this.btnJavadocUpdate);
        this.btnJavadocUpdate.setSelected(RefactoringModule.getOption(JAVADOC, Boolean.FALSE));
        this.btnJavadocUpdate.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnJavadocUpdate.text"));
        this.javadocButtonGroup.add(this.btnJavadocAsIs);
        this.btnJavadocAsIs.setSelected(Boolean.valueOf(RefactoringModule.getOption(JAVADOC, Boolean.FALSE)) == false);
        this.btnJavadocAsIs.setText(NbBundle.getMessage(MoveMembersPanel.class, (String)"MoveMembersPanel.btnJavadocAsIs.text"));
        GroupLayout javadocPanelLayout = new GroupLayout(this.javadocPanel);
        this.javadocPanel.setLayout(javadocPanelLayout);
        javadocPanelLayout.setHorizontalGroup(javadocPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(javadocPanelLayout.createSequentialGroup().addGroup(javadocPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnJavadocAsIs).addComponent(this.btnJavadocUpdate)).addGap(75, 75, 75)));
        javadocPanelLayout.setVerticalGroup(javadocPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(javadocPanelLayout.createSequentialGroup().addComponent(this.btnJavadocAsIs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnJavadocUpdate).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.chkDeprecate)).addGroup(layout.createSequentialGroup().addComponent(this.lblMoveMembersFrom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSource)).addComponent(this.chkDelegate)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.targetPanel, -1, -1, Short.MAX_VALUE).addComponent(this.membersListPanel, -1, 571, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.visibilityPanel, -1, -1, Short.MAX_VALUE).addComponent(this.javadocPanel, -1, 0, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMoveMembersFrom).addComponent(this.lblSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.visibilityPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javadocPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.targetPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.membersListPanel, -1, 299, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDelegate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDeprecate))).addContainerGap()));
    }

    private void chkDeprecateItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(DEPRECATE, b);
        this.parent.stateChanged(null);
    }

    private void chkDelegateItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(DELEGATE, b);
        this.chkDeprecate.setEnabled(b);
        this.parent.stateChanged(null);
    }

    private void projectsComboBoxItemStateChanged(ItemEvent evt) {
        this.project = (Project)this.projectsComboBox.getSelectedItem();
        this.updateRoots();
        this.updatePackages();
        this.updateClasses();
    }

    private void rootComboBoxItemStateChanged(ItemEvent evt) {
        this.updatePackages();
        this.updateClasses();
    }

    private void packageComboBoxItemStateChanged(ItemEvent evt) {
        this.updateClasses();
    }

    private void classComboBoxItemStateChanged(ItemEvent evt) {
        this.parent.stateChanged(null);
    }

    public List<? extends TreePathHandle> getHandles() {
        LinkedList<TreePathHandle> result = new LinkedList<TreePathHandle>();
        ElementNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getDescritption() != null) {
            for (ElementNode.Description description : rootNode.getDescritption().getSubs()) {
                if (description.getSelected() != Boolean.TRUE) continue;
                result.add(TreePathHandle.from(description.getElementHandle(), (ClasspathInfo)description.getCpInfo()));
            }
        }
        return result;
    }

    public boolean getDeprecated() {
        return this.chkDeprecate.isSelected();
    }

    public boolean getUpdateJavaDoc() {
        return this.btnJavadocUpdate.isSelected();
    }

    public boolean getDelegate() {
        return this.chkDelegate.isSelected();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public TreePathHandle getTarget() {
        Object selectedItem = this.classComboBox.getSelectedItem();
        if (selectedItem instanceof ClassItem) {
            ClassItem classItem = (ClassItem)selectedItem;
            return classItem.getHandle();
        }
        return null;
    }

    private void refresh(final ElementNode.Description description) {
        final MoveMembersPanel descriptionFilter = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoveMembersPanel.this.manager.setRootContext((Node)new ElementNode(description, descriptionFilter, MoveMembersPanel.this.parent));
                MoveMembersPanel.this.outlineView1.getOutline().setRootVisible(false);
                MoveMembersPanel.this.lblSource.setText("<html>" + description.getHtmlHeader());
                MoveMembersPanel.this.lblSource.setIcon(ElementIcons.getElementIcon((ElementKind)description.getKind(), description.getModifiers()));
            }
        });
    }

    @Override
    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    @Override
    public void filterStateChanged(ChangeEvent e) {
        ElementNode root = this.getRootNode();
        if (root != null) {
            root.refreshRecursively();
        }
    }

    public JavaMoveMembersProperties.Visibility getVisibility() {
        return JavaMoveMembersProperties.Visibility.valueOf(this.visibilityButtonGroup.getSelection().getActionCommand());
    }

    private static class PositionVisitor
    extends ErrorAwareTreePathScanner<Void, Map<Element, Long>> {
        private final Trees trees;
        private final SourcePositions sourcePositions;
        private final AtomicBoolean canceled;
        private CompilationUnitTree cu;

        public PositionVisitor(Trees trees, AtomicBoolean canceled) {
            assert (trees != null);
            assert (canceled != null);
            this.trees = trees;
            this.sourcePositions = trees.getSourcePositions();
            this.canceled = canceled;
        }

        public Void visitCompilationUnit(CompilationUnitTree node, Map<Element, Long> p) {
            this.cu = node;
            return (Void)super.visitCompilationUnit(node, p);
        }

        public Void visitClass(ClassTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return (Void)super.visitClass(node, p);
        }

        public Void visitMethod(MethodTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return null;
        }

        public Void visitVariable(VariableTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return null;
        }

        public Void scan(Tree tree, Map<Element, Long> p) {
            if (!this.canceled.get()) {
                return (Void)super.scan(tree, p);
            }
            return null;
        }
    }

    class ElementScanningTask
    implements CancellableTask<CompilationController> {
        private final AtomicBoolean canceled = new AtomicBoolean();

        public void cancel() {
            this.canceled.set(true);
        }

        public void run(CompilationController info) throws Exception {
            TypeElement topLevelElement;
            this.canceled.set(false);
            info.toPhase(JavaSource.Phase.RESOLVED);
            ElementNode.Description rootDescription = null;
            HashMap<Element, Long> pos = new HashMap<Element, Long>();
            TreePath typeElementPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)info, MoveMembersPanel.this.selectedElements[0].resolve((CompilationInfo)info), true, true, false, false, false);
            if (!this.canceled.get()) {
                Trees trees = info.getTrees();
                PositionVisitor posVis = new PositionVisitor(trees, this.canceled);
                posVis.scan((Tree)info.getCompilationUnit(), pos);
            }
            if (!this.canceled.get() && typeElementPath != null && null != (rootDescription = this.element2description(topLevelElement = (TypeElement)info.getTrees().getElement(typeElementPath), null, false, (CompilationInfo)info, pos))) {
                this.addMembers(topLevelElement, rootDescription, (CompilationInfo)info, pos);
            }
            if (!this.canceled.get()) {
                MoveMembersPanel.this.refresh(null != rootDescription ? rootDescription : new ElementNode.Description());
            }
        }

        private void addMembers(TypeElement e, ElementNode.Description parentDescription, CompilationInfo info, Map<Element, Long> pos) {
            List<? extends Element> members = e.getEnclosedElements();
            for (Element element : members) {
                if (this.canceled.get()) {
                    return;
                }
                ElementNode.Description d = this.element2description(element, e, parentDescription.isInherited(), info, pos);
                if (null == d) continue;
                parentDescription.getSubs().add(d);
                if (!(element instanceof TypeElement) || d.isInherited()) continue;
                this.addMembers((TypeElement)element, d, info, pos);
            }
        }

        private ElementNode.Description element2description(Element e, Element parent, boolean isParentInherited, CompilationInfo info, Map<Element, Long> pos) {
            if (info.getElementUtilities().isSynthetic(e)) {
                return null;
            }
            boolean inherited = isParentInherited || null != parent && !parent.equals(e.getEnclosingElement());
            ElementNode.Description d = new ElementNode.Description(e.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), e.getKind(), inherited);
            switch (e.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    if (parent == null) {
                        d.setSubs(new HashSet<ElementNode.Description>());
                        d.setHtmlHeader(UIUtilities.createHeader((TypeElement)e, info.getElements().isDeprecated(e), d.isInherited(), true, false));
                        break;
                    }
                    return null;
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    d.setHtmlHeader(UIUtilities.createHeader((VariableElement)e, info.getElements().isDeprecated(e), d.isInherited(), true, false));
                    break;
                }
                case METHOD: {
                    d.setHtmlHeader(UIUtilities.createHeader((ExecutableElement)e, info.getElements().isDeprecated(e), d.isInherited(), true, false));
                    break;
                }
                case CONSTRUCTOR: {
                    return null;
                }
                default: {
                    return null;
                }
            }
            d.setModifiers(e.getModifiers());
            d.setPos(this.getPosition(e, info, pos));
            d.setCpInfo(info.getClasspathInfo());
            d.setSelected(this.isSelected(e, info));
            return d;
        }

        private long getPosition(Element e, CompilationInfo info, Map<Element, Long> pos) {
            Long res = pos.get(e);
            if (res == null) {
                return -1L;
            }
            return res;
        }

        private Boolean isSelected(Element e, CompilationInfo info) {
            Boolean result = Boolean.FALSE;
            for (TreePathHandle tph : MoveMembersPanel.this.selectedElements) {
                if (!e.equals(tph.resolveElement(info))) continue;
                result = Boolean.TRUE;
                break;
            }
            return result;
        }
    }
}

