/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDbSystemPatchHistoryEntriesRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"dbSystemId", "limit", "page"})
    ListDbSystemPatchHistoryEntriesRequest(String dbSystemId, Integer limit, String page) {
        this.dbSystemId = dbSystemId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).limit(this.limit).page(this.page);
    }

    public String toString() {
        return "ListDbSystemPatchHistoryEntriesRequest(super=" + super.toString() + ", dbSystemId=" + this.getDbSystemId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDbSystemPatchHistoryEntriesRequest)) {
            return false;
        }
        ListDbSystemPatchHistoryEntriesRequest other = (ListDbSystemPatchHistoryEntriesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDbSystemPatchHistoryEntriesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemPatchHistoryEntriesRequest, Void> {
        private String dbSystemId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemPatchHistoryEntriesRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemPatchHistoryEntriesRequest build() {
            ListDbSystemPatchHistoryEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDbSystemPatchHistoryEntriesRequest buildWithoutInvocationCallback() {
            return new ListDbSystemPatchHistoryEntriesRequest(this.dbSystemId, this.limit, this.page);
        }

        public String toString() {
            return "ListDbSystemPatchHistoryEntriesRequest.Builder(dbSystemId=" + this.dbSystemId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

