/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDatabaseRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String ifMatch;
    private Boolean performFinalBackup;
    private String opcRequestId;

    @ConstructorProperties(value={"databaseId", "ifMatch", "performFinalBackup", "opcRequestId"})
    DeleteDatabaseRequest(String databaseId, String ifMatch, Boolean performFinalBackup, String opcRequestId) {
        this.databaseId = databaseId;
        this.ifMatch = ifMatch;
        this.performFinalBackup = performFinalBackup;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).ifMatch(this.ifMatch).performFinalBackup(this.performFinalBackup).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "DeleteDatabaseRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", ifMatch=" + this.getIfMatch() + ", performFinalBackup=" + this.getPerformFinalBackup() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteDatabaseRequest)) {
            return false;
        }
        DeleteDatabaseRequest other = (DeleteDatabaseRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$performFinalBackup = this.getPerformFinalBackup();
        Boolean other$performFinalBackup = other.getPerformFinalBackup();
        if (this$performFinalBackup == null ? other$performFinalBackup != null : !((Object)this$performFinalBackup).equals(other$performFinalBackup)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteDatabaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $performFinalBackup = this.getPerformFinalBackup();
        result = result * 59 + ($performFinalBackup == null ? 43 : ((Object)$performFinalBackup).hashCode());
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPerformFinalBackup() {
        return this.performFinalBackup;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDatabaseRequest, Void> {
        private String databaseId;
        private String ifMatch;
        private Boolean performFinalBackup;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.ifMatch(o.getIfMatch());
            this.performFinalBackup(o.getPerformFinalBackup());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDatabaseRequest build() {
            DeleteDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder performFinalBackup(Boolean performFinalBackup) {
            this.performFinalBackup = performFinalBackup;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDatabaseRequest buildWithoutInvocationCallback() {
            return new DeleteDatabaseRequest(this.databaseId, this.ifMatch, this.performFinalBackup, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDatabaseRequest.Builder(databaseId=" + this.databaseId + ", ifMatch=" + this.ifMatch + ", performFinalBackup=" + this.performFinalBackup + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

