/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseConnectionStringProfile {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="consumerGroup")
    private final ConsumerGroup consumerGroup;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="tlsAuthentication")
    private final TlsAuthentication tlsAuthentication;
    @JsonProperty(value="hostFormat")
    private final HostFormat hostFormat;
    @JsonProperty(value="sessionMode")
    private final SessionMode sessionMode;
    @JsonProperty(value="syntaxFormat")
    private final SyntaxFormat syntaxFormat;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().displayName(this.displayName).value(this.value).consumerGroup(this.consumerGroup).protocol(this.protocol).tlsAuthentication(this.tlsAuthentication).hostFormat(this.hostFormat).sessionMode(this.sessionMode).syntaxFormat(this.syntaxFormat);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getValue() {
        return this.value;
    }

    public ConsumerGroup getConsumerGroup() {
        return this.consumerGroup;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public TlsAuthentication getTlsAuthentication() {
        return this.tlsAuthentication;
    }

    public HostFormat getHostFormat() {
        return this.hostFormat;
    }

    public SessionMode getSessionMode() {
        return this.sessionMode;
    }

    public SyntaxFormat getSyntaxFormat() {
        return this.syntaxFormat;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseConnectionStringProfile)) {
            return false;
        }
        DatabaseConnectionStringProfile other = (DatabaseConnectionStringProfile)o;
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ConsumerGroup this$consumerGroup = this.getConsumerGroup();
        ConsumerGroup other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !((Object)((Object)this$consumerGroup)).equals((Object)other$consumerGroup)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        TlsAuthentication this$tlsAuthentication = this.getTlsAuthentication();
        TlsAuthentication other$tlsAuthentication = other.getTlsAuthentication();
        if (this$tlsAuthentication == null ? other$tlsAuthentication != null : !((Object)((Object)this$tlsAuthentication)).equals((Object)other$tlsAuthentication)) {
            return false;
        }
        HostFormat this$hostFormat = this.getHostFormat();
        HostFormat other$hostFormat = other.getHostFormat();
        if (this$hostFormat == null ? other$hostFormat != null : !((Object)((Object)this$hostFormat)).equals((Object)other$hostFormat)) {
            return false;
        }
        SessionMode this$sessionMode = this.getSessionMode();
        SessionMode other$sessionMode = other.getSessionMode();
        if (this$sessionMode == null ? other$sessionMode != null : !((Object)((Object)this$sessionMode)).equals((Object)other$sessionMode)) {
            return false;
        }
        SyntaxFormat this$syntaxFormat = this.getSyntaxFormat();
        SyntaxFormat other$syntaxFormat = other.getSyntaxFormat();
        if (this$syntaxFormat == null ? other$syntaxFormat != null : !((Object)((Object)this$syntaxFormat)).equals((Object)other$syntaxFormat)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ConsumerGroup $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : ((Object)((Object)$consumerGroup)).hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        TlsAuthentication $tlsAuthentication = this.getTlsAuthentication();
        result = result * 59 + ($tlsAuthentication == null ? 43 : ((Object)((Object)$tlsAuthentication)).hashCode());
        HostFormat $hostFormat = this.getHostFormat();
        result = result * 59 + ($hostFormat == null ? 43 : ((Object)((Object)$hostFormat)).hashCode());
        SessionMode $sessionMode = this.getSessionMode();
        result = result * 59 + ($sessionMode == null ? 43 : ((Object)((Object)$sessionMode)).hashCode());
        SyntaxFormat $syntaxFormat = this.getSyntaxFormat();
        result = result * 59 + ($syntaxFormat == null ? 43 : ((Object)((Object)$syntaxFormat)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseConnectionStringProfile(displayName=" + this.getDisplayName() + ", value=" + this.getValue() + ", consumerGroup=" + (Object)((Object)this.getConsumerGroup()) + ", protocol=" + (Object)((Object)this.getProtocol()) + ", tlsAuthentication=" + (Object)((Object)this.getTlsAuthentication()) + ", hostFormat=" + (Object)((Object)this.getHostFormat()) + ", sessionMode=" + (Object)((Object)this.getSessionMode()) + ", syntaxFormat=" + (Object)((Object)this.getSyntaxFormat()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"displayName", "value", "consumerGroup", "protocol", "tlsAuthentication", "hostFormat", "sessionMode", "syntaxFormat"})
    @Deprecated
    public DatabaseConnectionStringProfile(String displayName, String value, ConsumerGroup consumerGroup, Protocol protocol, TlsAuthentication tlsAuthentication, HostFormat hostFormat, SessionMode sessionMode, SyntaxFormat syntaxFormat) {
        this.displayName = displayName;
        this.value = value;
        this.consumerGroup = consumerGroup;
        this.protocol = protocol;
        this.tlsAuthentication = tlsAuthentication;
        this.hostFormat = hostFormat;
        this.sessionMode = sessionMode;
        this.syntaxFormat = syntaxFormat;
    }

    public static enum SyntaxFormat {
        Long("LONG"),
        Ezconnect("EZCONNECT"),
        Ezconnectplus("EZCONNECTPLUS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SyntaxFormat> map;

        private SyntaxFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SyntaxFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SyntaxFormat', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SyntaxFormat.class);
            map = new HashMap<String, SyntaxFormat>();
            for (SyntaxFormat v : SyntaxFormat.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SessionMode {
        Direct("DIRECT"),
        Redirect("REDIRECT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SessionMode> map;

        private SessionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SessionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SessionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SessionMode.class);
            map = new HashMap<String, SessionMode>();
            for (SessionMode v : SessionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum HostFormat {
        Fqdn("FQDN"),
        Ip("IP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HostFormat> map;

        private HostFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HostFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HostFormat', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HostFormat.class);
            map = new HashMap<String, HostFormat>();
            for (HostFormat v : HostFormat.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TlsAuthentication {
        Server("SERVER"),
        Mutual("MUTUAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TlsAuthentication> map;

        private TlsAuthentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TlsAuthentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TlsAuthentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TlsAuthentication.class);
            map = new HashMap<String, TlsAuthentication>();
            for (TlsAuthentication v : TlsAuthentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Protocol {
        Tcp("TCP"),
        Tcps("TCPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConsumerGroup {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Tp("TP"),
        Tpurgent("TPURGENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConsumerGroup> map;

        private ConsumerGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConsumerGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConsumerGroup', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConsumerGroup.class);
            map = new HashMap<String, ConsumerGroup>();
            for (ConsumerGroup v : ConsumerGroup.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="consumerGroup")
        private ConsumerGroup consumerGroup;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="tlsAuthentication")
        private TlsAuthentication tlsAuthentication;
        @JsonProperty(value="hostFormat")
        private HostFormat hostFormat;
        @JsonProperty(value="sessionMode")
        private SessionMode sessionMode;
        @JsonProperty(value="syntaxFormat")
        private SyntaxFormat syntaxFormat;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder consumerGroup(ConsumerGroup consumerGroup) {
            this.consumerGroup = consumerGroup;
            this.__explicitlySet__.add("consumerGroup");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder tlsAuthentication(TlsAuthentication tlsAuthentication) {
            this.tlsAuthentication = tlsAuthentication;
            this.__explicitlySet__.add("tlsAuthentication");
            return this;
        }

        public Builder hostFormat(HostFormat hostFormat) {
            this.hostFormat = hostFormat;
            this.__explicitlySet__.add("hostFormat");
            return this;
        }

        public Builder sessionMode(SessionMode sessionMode) {
            this.sessionMode = sessionMode;
            this.__explicitlySet__.add("sessionMode");
            return this;
        }

        public Builder syntaxFormat(SyntaxFormat syntaxFormat) {
            this.syntaxFormat = syntaxFormat;
            this.__explicitlySet__.add("syntaxFormat");
            return this;
        }

        public DatabaseConnectionStringProfile build() {
            DatabaseConnectionStringProfile __instance__ = new DatabaseConnectionStringProfile(this.displayName, this.value, this.consumerGroup, this.protocol, this.tlsAuthentication, this.hostFormat, this.sessionMode, this.syntaxFormat);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DatabaseConnectionStringProfile o) {
            Builder copiedBuilder = this.displayName(o.getDisplayName()).value(o.getValue()).consumerGroup(o.getConsumerGroup()).protocol(o.getProtocol()).tlsAuthentication(o.getTlsAuthentication()).hostFormat(o.getHostFormat()).sessionMode(o.getSessionMode()).syntaxFormat(o.getSyntaxFormat());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DatabaseConnectionStringProfile.Builder(displayName=" + this.displayName + ", value=" + this.value + ", consumerGroup=" + (Object)((Object)this.consumerGroup) + ", protocol=" + (Object)((Object)this.protocol) + ", tlsAuthentication=" + (Object)((Object)this.tlsAuthentication) + ", hostFormat=" + (Object)((Object)this.hostFormat) + ", sessionMode=" + (Object)((Object)this.sessionMode) + ", syntaxFormat=" + (Object)((Object)this.syntaxFormat) + ")";
        }
    }
}

